/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.neoforge;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.base.IPlatformHandlerApi;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.TransportState;

public interface NeoForgeItemStoragePlatform
extends IPlatformItemHandler,
IPlatformHandlerApi<ResourceHandler<ItemResource>> {
    default public int getContainerSize() {
        return ((ResourceHandler)this.getHandler()).size();
    }

    default public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (((ItemResource)((ResourceHandler)this.getHandler()).getResource(i)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    default public ItemStack getItem(int slot) {
        return ItemUtil.getStack((ResourceHandler)((ResourceHandler)this.getHandler()), (int)slot);
    }

    default public void setItem(int i, ItemStack arg) {
        this.extractItem(i, ((ResourceHandler)this.getHandler()).getAmountAsInt(i), false);
        this.insertItem(i, arg, false);
    }

    @Override
    default public void setChanged() {
    }

    @Override
    @NotNull
    default public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        try (Transaction transaction = Transaction.open(null);){
            int amount = ((ResourceHandler)this.getHandler()).insert(slot, (Resource)ItemResource.of((ItemStack)stack), stack.getCount(), (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            ItemStack itemStack = amount == 0 ? ItemStack.EMPTY : stack.copyWithCount(amount);
            return itemStack;
        }
    }

    @Override
    @NotNull
    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        try (Transaction transaction = Transaction.open(null);){
            int extracted = ((ResourceHandler)this.getHandler()).extract(slot, (Resource)((ItemResource)((ResourceHandler)this.getHandler()).getResource(slot)), ((ResourceHandler)this.getHandler()).getAmountAsInt(slot), (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            ItemStack itemStack = extracted == 0 ? ItemStack.EMPTY : ((ItemResource)((ResourceHandler)this.getHandler()).getResource(slot)).toStack(extracted);
            return itemStack;
        }
    }

    default public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
        return ((ResourceHandler)this.getHandler()).isValid(slot, (Resource)ItemResource.of((ItemStack)stack));
    }

    @Override
    default public TransportState getTransport() {
        return TransportState.EXTRACT_INSERT;
    }

    default public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.extractItem(i, ((ResourceHandler)this.getHandler()).getAmountAsInt(i), false);
        }
    }

    @Override
    default public CompoundTag serializeTag() {
        return new CompoundTag();
    }

    @Override
    default public void deserializeTag(CompoundTag tag) {
    }
}

