/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_465;
import net.minecraft.class_768;
import net.minecraft.class_918;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.FactoryGuiMatrixStack;
import wily.factoryapi.base.client.IWindowWidget;
import wily.factoryapi.base.client.drawable.AbstractDrawableButton;
import wily.factoryapi.base.client.drawable.DrawableStatic;
import wily.factoryapi.util.FactoryScreenUtil;

public abstract class FactoryScreenWindow<T extends class_465<?>>
extends class_339
implements IWindowWidget {
    public final AbstractDrawableButton<?> config;
    private double actualMouseX;
    private double actualMouseY;
    public boolean dragging = false;
    public class_2960 backgroundSprite;
    protected final class_918 itemRenderer;
    protected final class_327 font;
    protected final List<class_4068> nestedRenderables;
    protected final DrawableStatic drawable;
    public T parent;
    protected int lastX;
    protected int lastY;

    public FactoryScreenWindow(AbstractDrawableButton<?> config, DrawableStatic drawable, T parent) {
        super(drawable.method_3321(), drawable.method_3322(), drawable.width(), drawable.height(), (class_2561)class_2561.method_43473());
        this.font = class_310.method_1551().field_1772;
        this.nestedRenderables = new ArrayList<class_4068>();
        this.config = config;
        this.lastX = this.method_46426();
        this.lastY = this.method_46427();
        this.parent = parent;
        this.drawable = drawable;
        this.itemRenderer = class_310.method_1551().method_1480();
    }

    @Override
    public boolean isVisible() {
        return this.config.selected == Boolean.TRUE && (Boolean)this.config.visible.get() != false;
    }

    public void onClose() {
        this.config.selected = false;
        Consumer<FactoryScreenWindow> onClick = w -> {
            if (w.isVisible()) {
                w.onClickWidget();
            }
        };
        this.parent.method_25396().forEach(l -> {
            if (l instanceof FactoryScreenWindow) {
                FactoryScreenWindow s = (FactoryScreenWindow)l;
                onClick.accept(s);
            }
        });
        T t = this.parent;
        if (t instanceof IWindowWidget) {
            IWindowWidget w2 = (IWindowWidget)t;
            w2.getNestedRenderables().forEach(l -> {
                if (l instanceof FactoryScreenWindow) {
                    FactoryScreenWindow s = (FactoryScreenWindow)l;
                    onClick.accept(s);
                }
            });
        }
    }

    public void onClickWidget() {
        this.field_22765 = 1.0f;
        this.parent.method_25395((class_364)this);
    }

    public void onClickOutside(double mouseX, double mouseY) {
        this.method_25365(false);
        this.field_22765 = 0.88f;
    }

    public boolean method_25404(int i, int j, int k) {
        if (i == 256 && this.isVisible()) {
            this.onClose();
            return true;
        }
        return false;
    }

    protected void renderBg(class_332 graphics, int i, int j, float f) {
        FactoryGuiMatrixStack.of(graphics.method_51448()).pushPose();
        FactoryScreenUtil.enableBlend();
        FactoryScreenUtil.enableDepthTest();
        if (this.backgroundSprite != null) {
            FactoryGuiGraphics.of(graphics).blitSprite(this.backgroundSprite, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
        } else {
            this.drawable.draw(graphics, this.method_46426(), this.method_46427());
        }
        IWindowWidget.super.method_25394(graphics, i, j, f);
        FactoryScreenUtil.disableBlend();
        FactoryScreenUtil.disableDepthTest();
        FactoryGuiMatrixStack.of(graphics.method_51448()).popPose();
    }

    @Override
    public List<? extends class_4068> getNestedRenderables() {
        return this.nestedRenderables;
    }

    @Override
    public <R extends class_4068> R addNestedRenderable(R drawable) {
        this.nestedRenderables.add(drawable);
        return drawable;
    }

    protected void method_48579(class_332 graphics, int i, int j, float f) {
        if (!this.isVisible()) {
            return;
        }
        FactoryGuiMatrixStack.of(graphics.method_51448()).pushPose();
        FactoryGuiMatrixStack.of(graphics.method_51448()).translate(0.0, 0.0, this.getBlitOffset());
        this.renderBg(graphics, i, j, f);
        this.renderToolTip(graphics, i, j);
        FactoryGuiMatrixStack.of(graphics.method_51448()).popPose();
    }

    public float getBlitOffset() {
        return 450.0f;
    }

    public void renderToolTip(class_332 graphics, int i, int j) {
    }

    public boolean method_25405(double d, double e) {
        return this.isVisible() && FactoryScreenUtil.isMouseOver(d, e, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
    }

    public void updateActualMouse(double mouseX, double mouseY) {
        this.actualMouseX = mouseX;
        this.actualMouseY = mouseY;
    }

    public void updateLastMouse(int mouseX, int mouseY) {
        this.lastX = mouseX;
        this.lastY = mouseY;
    }

    @Override
    public boolean method_25402(double d, double e, int i) {
        return this.handleClick(d, e, i) || IWindowWidget.super.method_25402(d, e, i);
    }

    @Override
    public boolean method_25406(double d, double e, int i) {
        return this.handleRelease(d, e, i) || IWindowWidget.super.method_25406(d, e, i);
    }

    @Override
    public boolean method_25403(double x, double y, int i, double dx, double dy) {
        if (!this.isVisible() || this.parent.method_25397() && !this.dragging) {
            return false;
        }
        if (IWindowWidget.super.method_25403(x, y, i, dx, dy)) {
            return true;
        }
        return this.handleDragging(x, y, i, dx, dy);
    }

    public boolean handleClick(double d, double e, int i) {
        if (!this.isVisible()) {
            return false;
        }
        if (i == 0) {
            if (this.method_25405(d, e) || this.config.method_25405(d, e)) {
                this.onClickWidget();
                if (this.method_25405(d, e)) {
                    this.updateActualMouse(d, e);
                }
            } else {
                this.onClickOutside(d, e);
            }
        }
        return false;
    }

    public boolean handleRelease(double d, double e, int i) {
        if (this.dragging) {
            this.dragging = false;
            this.parent.method_25398(false);
            this.updateLastMouse(this.method_46426(), this.method_46427());
            return true;
        }
        return false;
    }

    public boolean handleDragging(double x, double y, int i, double dx, double dy) {
        if (i == 0 && (this.method_25405(x, y) || this.dragging)) {
            double newX = (double)this.lastX + x - this.actualMouseX;
            double newY = (double)this.lastY + y - this.actualMouseY;
            if (newX + (double)this.field_22758 < (double)((class_465)this.parent).field_22789 && newX > 0.0) {
                this.method_46421((int)newX);
            }
            if (newY + (double)this.field_22759 < (double)((class_465)this.parent).field_22790 && newY > 0.0) {
                this.method_46419((int)newY);
            }
            this.dragging = true;
            this.parent.method_25398(true);
            return true;
        }
        return false;
    }

    @Override
    public class_768 getBounds() {
        return new class_768(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
    }
}

