/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public class CompoundTagUtil {
    public static CompoundTag getCompoundTagOrEmpty(CompoundTag tag, String name) {
        return tag.getCompound(name);
    }

    public static Optional<CompoundTag> getCompoundTag(CompoundTag tag, String name) {
        return tag.contains(name) ? Optional.of(tag.getCompound(name)) : Optional.empty();
    }

    public static Optional<Boolean> getBoolean(CompoundTag tag, String name) {
        return tag.contains(name) ? Optional.of(tag.getBoolean(name)) : Optional.empty();
    }

    public static Optional<Byte> getByte(CompoundTag tag, String name) {
        return tag.contains(name) ? Optional.of(tag.getByte(name)) : Optional.empty();
    }

    public static Optional<Integer> getInt(CompoundTag tag, String name) {
        return tag.contains(name) ? Optional.of(tag.getInt(name)) : Optional.empty();
    }

    public static Optional<Long> getLong(CompoundTag tag, String name) {
        return tag.contains(name) ? Optional.of(tag.getLong(name)) : Optional.empty();
    }

    public static Optional<Float> getFloat(CompoundTag tag, String name) {
        return tag.contains(name) ? Optional.of(Float.valueOf(tag.getFloat(name))) : Optional.empty();
    }

    public static Optional<Double> getDouble(CompoundTag tag, String name) {
        return tag.contains(name) ? Optional.of(tag.getDouble(name)) : Optional.empty();
    }

    public static Optional<byte[]> getByteArray(CompoundTag tag, String name) {
        return tag.contains(name) ? Optional.of(tag.getByteArray(name)) : Optional.empty();
    }

    public static Optional<int[]> getIntArray(CompoundTag tag, String name) {
        return tag.contains(name) ? Optional.of(tag.getIntArray(name)) : Optional.empty();
    }

    public static Optional<long[]> getLongArray(CompoundTag tag, String name) {
        return tag.contains(name) ? Optional.of(tag.getLongArray(name)) : Optional.empty();
    }

    public static byte[] getByteArrayOrEmpty(CompoundTag tag, String name) {
        return tag.getByteArray(name);
    }

    public static int[] getIntArrayOrEmpty(CompoundTag tag, String name) {
        return tag.getIntArray(name);
    }

    public static long[] getLongArrayOrEmpty(CompoundTag tag, String name) {
        return tag.getLongArray(name);
    }

    public static Optional<String> getString(CompoundTag tag, String name) {
        return tag.contains(name) ? Optional.of(tag.getString(name)) : Optional.empty();
    }
}

