/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import java.util.function.Function;
import net.minecraft.class_2350;
import wily.factoryapi.base.CraftyTransaction;
import wily.factoryapi.base.FactoryStorage;
import wily.factoryapi.base.ICraftyEnergyStorage;
import wily.factoryapi.base.IFactoryStorage;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.util.FluidInstance;

public class StorageUtil {
    public static void transferEnergyTo(IFactoryStorage fromStorage, class_2350 d, ICraftyEnergyStorage energyReceiver) {
        StorageUtil.transferEnergyTo(fromStorage, c -> c, c -> c, d, energyReceiver);
    }

    public static void transferEnergyFrom(IFactoryStorage fromStorage, class_2350 d, ICraftyEnergyStorage energyConsumer) {
        StorageUtil.transferEnergyFrom(fromStorage, c -> c, c -> c, d, energyConsumer);
    }

    public static void transferEnergyTo(IFactoryStorage fromStorage, Function<CraftyTransaction, CraftyTransaction> transferFunction, Function<CraftyTransaction, CraftyTransaction> consumeFunction, class_2350 d, ICraftyEnergyStorage energyReceiver) {
        fromStorage.getStorage(FactoryStorage.CRAFTY_ENERGY, d).ifPresent(e -> {
            CraftyTransaction transaction1 = e.consumeEnergy((CraftyTransaction)transferFunction.apply(new CraftyTransaction(e.getMaxConsume(), e.getStoredTier())), true);
            e.consumeEnergy((CraftyTransaction)consumeFunction.apply(energyReceiver.receiveEnergy(transaction1, false)), false);
        });
    }

    public static void transferEnergyFrom(IFactoryStorage fromStorage, Function<CraftyTransaction, CraftyTransaction> transferFunction, Function<CraftyTransaction, CraftyTransaction> consumeFunction, class_2350 d, ICraftyEnergyStorage energyConsumer) {
        fromStorage.getStorage(FactoryStorage.CRAFTY_ENERGY, d).ifPresent(e -> {
            CraftyTransaction transaction = energyConsumer.consumeEnergy((CraftyTransaction)transferFunction.apply(new CraftyTransaction(energyConsumer.getMaxConsume(), energyConsumer.getStoredTier())), true);
            energyConsumer.consumeEnergy((CraftyTransaction)consumeFunction.apply(e.receiveEnergy(transaction, false)), false);
        });
    }

    public static void transferFluidTo(IFactoryStorage fromStorage, class_2350 d, IPlatformFluidHandler fluidFiller) {
        StorageUtil.transferFluidTo(fromStorage, c -> c, d, fluidFiller);
    }

    public static void transferFluidFrom(IFactoryStorage toStorage, class_2350 d, IPlatformFluidHandler fluidFiller) {
        StorageUtil.transferFluidFrom(toStorage, c -> c, d, fluidFiller);
    }

    public static void transferFluidTo(IFactoryStorage fromStorage, Function<FluidInstance, FluidInstance> transaction, class_2350 d, IPlatformFluidHandler fluidFiller) {
        fromStorage.getStorage(FactoryStorage.FLUID, d).ifPresent(e -> e.drain(fluidFiller.fill((FluidInstance)transaction.apply(e.getFluidInstance()), false), false));
    }

    public static void transferFluidFrom(IFactoryStorage toStorage, Function<FluidInstance, FluidInstance> transaction, class_2350 d, IPlatformFluidHandler fluidDrainer) {
        toStorage.getStorage(FactoryStorage.FLUID, d).ifPresent(e -> fluidDrainer.drain(e.fill((FluidInstance)transaction.apply(fluidDrainer.getFluidInstance()), false), false));
    }
}

