/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi;

import com.mojang.brigadier.CommandDispatcher;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2314;
import net.minecraft.class_2960;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.TriConsumer;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.base.config.FactoryCommonOptions;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.fabric.FabricStorages;
import wily.factoryapi.base.network.CommonConfigSyncPayload;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.base.network.FactoryAPICommand;
import wily.factoryapi.base.network.HelloPayload;
import wily.factoryapi.base.network.OpenExtraMenuPayload;
import wily.factoryapi.base.network.SecureExecutor;
import wily.factoryapi.init.FactoryRegistries;

public class FactoryAPI {
    public static final String MOD_ID = "factory_api";
    public static final SecureExecutor SECURE_EXECUTOR = new SecureExecutor(){

        @Override
        public boolean isSecure() {
            return true;
        }
    };
    public static final Logger LOGGER = LogManager.getLogger((String)"factory_api");
    public static MinecraftServer currentServer;

    public FactoryAPI() {
        FactoryAPI.init();
    }

    public static void init() {
        LOGGER.info("Initializing FactoryAPI!");
        FactoryConfig.registerCommonStorage(FactoryAPI.createModLocation("common"), FactoryCommonOptions.COMMON_STORAGE);
        FactoryEvent.registerPayload(r -> {
            r.register(false, FactoryAPICommand.UIDefinitionPayload.ID);
            r.register(false, HelloPayload.ID_S2C);
            r.register(true, HelloPayload.ID_C2S);
            r.register(false, CommonConfigSyncPayload.ID_S2C);
            r.register(true, CommonConfigSyncPayload.ID_C2S);
            r.register(false, OpenExtraMenuPayload.ID);
        });
        FactoryEvent.preServerTick(s -> SECURE_EXECUTOR.executeAll());
        FactoryEvent.registerCommands((TriConsumer<CommandDispatcher<class_2168>, class_7157, class_2170.class_5364>)((TriConsumer)(commandSourceStackCommandDispatcher, commandBuildContext, commandSelection) -> FactoryAPICommand.register((CommandDispatcher<class_2168>)commandSourceStackCommandDispatcher, commandBuildContext)));
        FactoryRegistries.init();
        FactoryIngredient.init();
        FactoryEvent.setup(() -> {
            FactoryAPIPlatform.registerByClassArgumentType(FactoryAPICommand.JsonArgument.class, (class_2314)FactoryRegistries.JSON_ARGUMENT_TYPE.get());
            FactoryCommonOptions.COMMON_STORAGE.load();
        });
        FactoryEvent.PlayerEvent.JOIN_EVENT.register(HelloPayload::sendInitialPayloads);
        FactoryEvent.PlayerEvent.REMOVED_EVENT.register(sp -> CommonNetwork.ENABLED_PLAYERS.removeAll((Object)sp.method_5667()));
        FactoryEvent.serverStopped(s -> {
            SECURE_EXECUTOR.clear();
            CommonNetwork.ENABLED_PLAYERS.clear();
            currentServer = null;
        });
        FabricStorages.registerDefaultStorages();
    }

    public static class_2960 createLocation(String namespace, String path) {
        return class_2960.method_43902((String)namespace, (String)path);
    }

    public static class_2960 createLocation(String location) {
        return class_2960.method_12829((String)location);
    }

    public static class_2960 createModLocation(String path) {
        return FactoryAPI.createLocation(MOD_ID, path);
    }

    public static class_2960 createVanillaLocation(String path) {
        return new class_2960(path);
    }

    public static Loader getLoader() {
        return Loader.FABRIC;
    }

    public static boolean isLoadingMod(String modId) {
        return FactoryAPI.isModLoaded(modId);
    }

    public static boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    public static Path getConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static <T> Field getAccessibleField(Class<T> fieldClass, String field) {
        try {
            Field f = fieldClass.getDeclaredField(field);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException var1) {
            throw new IllegalStateException("Couldn't get field %s for %s".formatted(field, fieldClass), var1);
        }
    }

    public static <T> Map<String, Field> getAccessibleFieldsMap(Class<T> fieldsClass, String ... fields) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (String s : fields) {
            map.put(s, FactoryAPI.getAccessibleField(fieldsClass, s));
        }
        return map;
    }

    public static enum Loader {
        FABRIC,
        FORGE,
        NEOFORGE;


        public boolean isForgeLike() {
            return this == FORGE || this == NEOFORGE;
        }

        public boolean isFabric() {
            return this == FABRIC;
        }
    }
}

