/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.base.IHasIdentifier;
import wily.factoryapi.base.IPlatformHandler;
import wily.factoryapi.base.ITagSerializable;
import wily.factoryapi.util.FluidInstance;

public interface IPlatformFluidHandler
extends ITagSerializable<class_2487>,
IPlatformHandler,
IHasIdentifier,
SingleSlotStorage<FluidVariant> {
    @NotNull
    public FluidInstance getFluidInstance();

    public int getMaxFluid();

    public boolean isFluidValid(@NotNull FluidInstance var1);

    public int fill(FluidInstance var1, boolean var2);

    @NotNull
    public FluidInstance drain(FluidInstance var1, boolean var2);

    @NotNull
    public FluidInstance drain(int var1, boolean var2);

    default public int getTotalSpace() {
        return Math.max(0, this.getMaxFluid() - this.getFluidInstance().getAmount());
    }

    public void setFluid(FluidInstance var1);

    default public void setCapacity(int capacity) {
        throw new UnsupportedOperationException("This Platform Fluid Handler capacity can't be modified!");
    }

    default public String getName() {
        return this.identifier().getName() + "Tank";
    }

    @Override
    default public void deserializeTag(class_2487 tag) {
        this.setFluid(FluidInstance.fromTag(tag));
        class_2520 t = (class_2520)tag.field_11515.get("capacity");
        if (t instanceof class_2514) {
            if (t instanceof class_2503) {
                class_2503 l = (class_2503)t;
                this.setCapacity(FluidInstance.getMilliBucketsFluidAmount(l.method_10699()));
            } else if (t instanceof class_2497) {
                class_2497 i = (class_2497)t;
                this.setCapacity(i.method_10701());
            }
        }
    }

    @Override
    default public class_2487 serializeTag() {
        class_2487 tag = FluidInstance.toTag(this.getFluidInstance());
        tag.method_10569("capacity", this.getMaxFluid());
        return tag;
    }

    default public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        FluidInstance instance = FluidInstance.create(resource.getFluid(), maxAmount);
        transaction.addCloseCallback((t, r) -> {
            if (r.wasCommitted()) {
                this.fill(instance, false);
            }
        });
        return FluidInstance.getPlatformFluidAmount(this.fill(instance, true));
    }

    default public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        FluidInstance instance = FluidInstance.create(resource.getFluid(), maxAmount);
        transaction.addCloseCallback((t, r) -> {
            if (r.wasCommitted()) {
                this.drain(instance, false);
            }
        });
        return this.drain(instance, true).getPlatformAmount();
    }

    default public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    default public FluidVariant getResource() {
        return this.getFluidInstance().toVariant();
    }

    default public long getAmount() {
        return this.getFluidInstance().getPlatformAmount();
    }

    default public long getCapacity() {
        return FluidInstance.getPlatformFluidAmount(this.getMaxFluid());
    }
}

