/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3936;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_642;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.FactoryGuiMatrixStack;
import wily.factoryapi.base.client.FactoryOptions;
import wily.factoryapi.base.client.UIDefinition;
import wily.factoryapi.base.client.WidgetAccessor;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.factoryapi.util.VariableResolver;
import wily.factoryapi.util.VariablesMap;

public interface UIAccessor
extends UIDefinition,
VariableResolver {
    public static UIAccessor of(class_437 screen) {
        return (UIAccessor)screen;
    }

    public static UIAccessor of(class_329 gui) {
        return (UIAccessor)gui;
    }

    @Nullable
    public class_437 getScreen();

    default public void reloadUI() {
        this.beforeInit();
        this.getChildrenRenderables().clear();
        this.afterInit();
    }

    public boolean initialized();

    @Override
    default public void beforeInit(UIAccessor accessor) {
        class_1661 inventory;
        this.getElements().clear();
        this.putStaticElement("windowWidth", class_310.method_1551().method_22683().method_4489());
        this.putStaticElement("windowHeight", class_310.method_1551().method_22683().method_4506());
        this.putStaticElement("width", class_310.method_1551().method_22683().method_4486());
        this.putStaticElement("height", class_310.method_1551().method_22683().method_4502());
        this.getElements().put("hasScreen", () -> class_310.method_1551().field_1755 != null);
        if (this.getChildrenRenderables() != null) {
            this.getElements().put("renderablesCount", this.getChildrenRenderables()::size);
        }
        FactoryAPIPlatform.getMods().forEach(i -> this.putStaticElement("loadedMods." + i.getId(), true));
        class_642 serverData = class_310.method_1551().method_1558();
        if (serverData != null) {
            this.putStaticElement("serverIp." + serverData.field_3761, true);
        }
        class_1661 class_16612 = inventory = class_310.method_1551().field_1724 == null ? null : class_310.method_1551().field_1724.method_31548();
        if (inventory != null) {
            int index;
            class_2371 items = inventory.field_7547;
            int i2 = 0;
            while (i2 < items.size()) {
                index = i2++;
                this.getElements().put("inventory." + index, () -> UIAccessor.lambda$beforeInit$2((List)items, index));
            }
            i2 = 0;
            while (i2 < inventory.field_7548.size()) {
                index = i2++;
                this.getElements().put("inventory.armor." + index, () -> inventory.field_7548.get(index));
            }
            this.getElements().put("inventory.offhand", () -> inventory.field_7544.get(0));
        }
        this.putSupplierComponent("username", () -> class_2561.method_43470((String)class_310.method_1551().method_1548().method_1676()));
        class_437 class_4372 = this.getScreen();
        if (class_4372 instanceof class_3936) {
            class_3936 access = (class_3936)class_4372;
            this.getElements().put("slotsCount", () -> ((class_2371)access.method_17577().field_7761).size());
            for (class_1735 slot : access.method_17577().field_7761) {
                this.getElements().put("menu.slot." + slot.method_34266(), () -> ((class_1735)slot).method_7677());
            }
        }
        this.getDefinitions().clear();
        FactoryAPIClient.uiDefinitionManager.applyStatic(accessor);
        this.getDefinitions().addAll(this.getStaticDefinitions());
        FactoryAPIClient.uiDefinitionManager.apply(accessor);
        UIDefinition.super.beforeInit(accessor);
    }

    default public void beforeInit() {
        this.beforeInit(this);
    }

    default public void afterInit() {
        this.afterInit(this);
        if (((Boolean)FactoryOptions.UI_DEFINITION_LOGGING.get()).booleanValue()) {
            FactoryAPI.LOGGER.warn(this.getElements());
        }
    }

    default public void beforeTick() {
        this.beforeTick(this);
    }

    default public void afterTick() {
        this.afterTick(this);
    }

    public List<class_364> getChildren();

    public List<class_4068> getChildrenRenderables();

    public <T extends class_364> T removeChild(T var1);

    public <T extends class_364> T addChild(int var1, T var2, boolean var3, boolean var4);

    default public <T extends class_364> T addChild(int renderableIndex, T listener) {
        return this.addChild(renderableIndex, listener, true, true);
    }

    default public <T extends class_364> T addChild(String name, T listener) {
        return this.addChild(this.getInteger(name + ".order", this.getChildrenRenderables().size()), listener);
    }

    default public <T extends class_4068> T addRenderable(T renderable) {
        return this.addRenderable(this.getChildrenRenderables().size(), renderable);
    }

    default public <T extends class_4068> T addRenderable(int index, T renderable) {
        this.getChildrenRenderables().add(Math.min(Math.max(0, index), this.getChildrenRenderables().size()), renderable);
        return renderable;
    }

    default public <T extends class_4068> T addRenderable(String name, T renderable) {
        return this.addRenderable(this.getInteger(name + ".order", this.getChildrenRenderables().size()), renderable);
    }

    public VariablesMap<String, ArbitrarySupplier<?>> getElements();

    default public <E> E putStaticElement(String name, E e) {
        this.getElements().put(name, ArbitrarySupplier.of(e));
        return e;
    }

    default public <E> E putBearer(String name, Bearer<E> e, Function<Object, E> convertOldValue) {
        ArbitrarySupplier oldElement = this.getElements().put(name, e);
        if (oldElement != null) {
            oldElement.map(convertOldValue::apply).ifPresent(e::set);
        }
        return (E)e.get();
    }

    default public <E> E putBearer(String name, Bearer<E> e) {
        return (E)this.putBearer(name, e, o -> o);
    }

    default public Integer putIntegerBearer(String name, Bearer<Integer> e) {
        return this.putBearer(name, e, o -> {
            Integer n;
            if (o instanceof Number) {
                Number n2 = (Number)o;
                n = n2.intValue();
            } else if (o instanceof String) {
                String s = (String)o;
                n = Integer.parseInt(s);
            } else {
                n = null;
            }
            return n;
        });
    }

    default public <E extends class_339> E putWidget(String name, E e) {
        this.putBearer(name + ".message", Bearer.of(() -> e.method_25369(), arg_0 -> e.method_25355(arg_0)));
        this.getElement(name + ".tooltip", class_2561.class).ifPresent(c -> e.method_47400(class_7919.method_47407((class_2561)c)));
        this.putBearer(name + ".spriteOverride", Bearer.of(WidgetAccessor.of(e)::getSpriteOverride, WidgetAccessor.of(e)::setSpriteOverride));
        this.putBearer(name + ".highlightedSpriteOverride", Bearer.of(WidgetAccessor.of(e)::getSpriteOverride, WidgetAccessor.of(e)::setHighlightedSpriteOverride));
        this.putBearer(name + ".onPressOverride", Bearer.of(WidgetAccessor.of(e)::getOnPressOverride, WidgetAccessor.of(e)::setOnPressOverride));
        WidgetAccessor.of(e).setVisibility(this.getElement(name + ".isVisible", Boolean.class));
        return this.putLayoutElement(name, e, arg_0 -> e.method_25358(arg_0), WidgetAccessor.of(e)::setHeight);
    }

    default public class_2561 putComponent(String name, class_2561 component) {
        this.putStaticElement(name, component);
        this.putStaticElement(name + ".width", class_310.method_1551().field_1772.method_27525((class_5348)component));
        return component;
    }

    default public void putSupplierComponent(String name, ArbitrarySupplier<class_2561> component) {
        this.getElements().put(name, component);
        this.getElements().put(name + ".width", component.map(c -> class_310.method_1551().field_1772.method_27525((class_5348)c)));
    }

    default public class_243 putVec3(String name, class_243 vec3) {
        this.putStaticElement(name, vec3);
        this.putStaticElement(name + ".x", vec3.method_10216());
        this.putStaticElement(name + ".y", vec3.method_10214());
        this.putStaticElement(name + ".z", vec3.method_10215());
        return vec3;
    }

    default public class_241 putVec2(String name, class_241 offset) {
        this.putStaticElement(name, offset);
        this.putStaticElement(name + ".x", Float.valueOf(offset.field_1343));
        this.putStaticElement(name + ".y", Float.valueOf(offset.field_1342));
        return offset;
    }

    default public class_4068 createModifiableRenderable(String name, class_4068 renderable) {
        return (guiGraphics, i, j, f) -> {
            int amount = this.getInteger(name + ".amount", 1);
            for (int i1 = 0; i1 < amount; ++i1) {
                ArbitrarySupplier<?> patt0$temp = this.getElements().get(name + ".index");
                if (patt0$temp instanceof Bearer) {
                    Bearer b = (Bearer)patt0$temp;
                    b.secureCast(Integer.class).set(i1);
                }
                FactoryGuiMatrixStack.of(guiGraphics.method_51448()).pushPose();
                int color = this.getInteger(name + ".renderColor", -1);
                FactoryScreenUtil.enableBlend();
                FactoryGuiGraphics.of(guiGraphics).setColor(color);
                FactoryGuiMatrixStack.of(guiGraphics.method_51448()).translate(this.getDouble(name + ".translateX", 0.0), this.getDouble(name + ".translateY", 0.0), this.getDouble(name + ".translateZ", 0.0));
                FactoryGuiMatrixStack.of(guiGraphics.method_51448()).scale(this.getFloat(name + ".scaleX", 1.0f), this.getFloat(name + ".scaleY", 1.0f), this.getFloat(name + ".scaleZ", 1.0f));
                renderable.method_25394(guiGraphics, i, j, f);
                FactoryGuiMatrixStack.of(guiGraphics.method_51448()).popPose();
                FactoryScreenUtil.disableBlend();
                FactoryGuiGraphics.of(guiGraphics).clearColor();
            }
        };
    }

    default public <E extends class_8021> E putLayoutElement(String name, E e, Consumer<Integer> setWidth, Consumer<Integer> setHeight) {
        this.putIntegerBearer(name + ".x", Bearer.of(() -> e.method_46426(), arg_0 -> e.method_46421(arg_0)));
        this.putIntegerBearer(name + ".y", Bearer.of(() -> e.method_46427(), arg_0 -> e.method_46419(arg_0)));
        this.putIntegerBearer(name + ".width", Bearer.of(() -> e.method_25368(), setWidth));
        this.putIntegerBearer(name + ".height", Bearer.of(() -> e.method_25364(), setHeight));
        return this.putStaticElement(name, e);
    }

    default public String replaceValidElementValues(String s) {
        this.getElements().updatePattern();
        Matcher matcher = this.getElements().getPattern().matcher(s);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String key = matcher.group(1);
            matcher.appendReplacement(result, String.valueOf(this.getElements().get(key).get()));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    default public <V> ArbitrarySupplier<V> getElement(String name, Class<V> valueClass) {
        return this.getElements().getOrDefault(name, ArbitrarySupplier.empty()).secureCast(valueClass);
    }

    default public ArbitrarySupplier<?> getElement(String name) {
        return this.getElements().getOrDefault(name, ArbitrarySupplier.empty());
    }

    default public ArbitrarySupplier<Boolean> getBooleanElement(String name) {
        return this.getElement(name, Boolean.class);
    }

    default public ArbitrarySupplier<Integer> getIntegerElement(String name) {
        return this.getElement(name, Number.class).map(Number::intValue);
    }

    default public <V> V getElementValue(String name, V defaultValue, Class<V> valueClass) {
        Object value;
        ArbitrarySupplier<?> element = this.getElements().get(name);
        return element != null && valueClass.isInstance(value = element.get()) ? valueClass.cast(value) : defaultValue;
    }

    default public int getInteger(String name, int defaultValue) {
        return this.getElementValue(name, defaultValue, Number.class).intValue();
    }

    default public double getDouble(String name, double defaultValue) {
        return this.getElementValue(name, defaultValue, Number.class).doubleValue();
    }

    default public float getFloat(String name, float defaultValue) {
        return this.getElementValue(name, Float.valueOf(defaultValue), Number.class).floatValue();
    }

    @Override
    default public Boolean getBoolean(String name, Boolean defaultValue) {
        return this.getElementValue(name, defaultValue, Boolean.class);
    }

    default public Boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    default public class_2960 getResourceLocation(String name, class_2960 defaultValue) {
        return this.getElementValue(name, defaultValue, class_2960.class);
    }

    default public class_2960 getResourceLocation(String name) {
        return this.getResourceLocation(name, null);
    }

    default public class_1799 getItemStack(String name) {
        return this.getElementValue(name, class_1799.field_8037, class_1799.class);
    }

    default public class_1799 getItemStack(String name, class_1799 defaultValue) {
        return this.getElementValue(name, defaultValue, class_1799.class);
    }

    default public class_2561 getComponent(String name, class_2561 defaultValue) {
        return this.getElementValue(name, defaultValue, class_2561.class);
    }

    default public class_2561 getComponent(String name) {
        return this.getComponent(name, null);
    }

    default public class_243 getVec3(String name, class_243 defaultValue) {
        return this.getElementValue(name, defaultValue, class_243.class);
    }

    default public class_243 getVec3(String name) {
        return this.getVec3(name, null);
    }

    @Override
    default public Number getNumber(String name, Number defaultValue) {
        return this.getElementValue(name, defaultValue, Number.class);
    }

    public static UIAccessor createRenderablesWrapper(final UIAccessor accessor, final List<class_4068> renderables) {
        return new UIAccessor(){

            @Override
            @Nullable
            public class_437 getScreen() {
                return accessor.getScreen();
            }

            @Override
            public List<UIDefinition> getDefinitions() {
                return accessor.getDefinitions();
            }

            @Override
            public void reloadUI() {
                accessor.reloadUI();
            }

            @Override
            public boolean initialized() {
                return accessor.initialized();
            }

            @Override
            public List<UIDefinition> getStaticDefinitions() {
                return accessor.getStaticDefinitions();
            }

            @Override
            public List<class_364> getChildren() {
                return Collections.emptyList();
            }

            @Override
            public List<class_4068> getChildrenRenderables() {
                return renderables;
            }

            @Override
            public <T extends class_364> T removeChild(T widget) {
                if (widget instanceof class_4068) {
                    renderables.remove(widget);
                }
                return widget;
            }

            @Override
            public <T extends class_364> T addChild(int renderableIndex, T listener, boolean isRenderable, boolean isNarratable) {
                if (isRenderable && listener instanceof class_4068) {
                    class_4068 r = (class_4068)listener;
                    renderables.add(renderableIndex, r);
                }
                return listener;
            }

            @Override
            public VariablesMap<String, ArbitrarySupplier<?>> getElements() {
                return accessor.getElements();
            }
        };
    }

    private static /* synthetic */ Object lambda$beforeInit$2(List items, int index) {
        return items.get(index);
    }
}

