/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.UIAccessor;

public interface UIDefinition
extends Predicate<UIAccessor> {
    public static final UIDefinition EMPTY = new UIDefinition(){};

    default public void beforeInit(UIAccessor accessor) {
        this.getDefinitions().removeIf(d -> {
            if (d.test(accessor)) {
                d.beforeInit(accessor);
                return false;
            }
            return true;
        });
    }

    default public void afterInit(UIAccessor accessor) {
        this.getDefinitions().forEach(d -> d.afterInit(accessor));
    }

    default public void beforeTick(UIAccessor accessor) {
        this.getDefinitions().forEach(d -> d.beforeTick(accessor));
    }

    default public void afterTick(UIAccessor accessor) {
        this.getDefinitions().forEach(d -> d.afterTick(accessor));
    }

    default public List<UIDefinition> getDefinitions() {
        return Collections.emptyList();
    }

    default public List<UIDefinition> getStaticDefinitions() {
        return Collections.emptyList();
    }

    default public void addStatic(UIDefinition uiDefinition) {
        this.getStaticDefinitions().add(uiDefinition);
    }

    public static UIDefinition createBeforeInit(final Consumer<UIAccessor> beforeInit) {
        return new UIDefinition(){

            @Override
            public void beforeInit(UIAccessor accessor) {
                beforeInit.accept(accessor);
            }
        };
    }

    @Deprecated
    public static UIDefinition createBeforeInit(String name, Consumer<UIAccessor> beforeInit) {
        return UIDefinition.createBeforeInit(beforeInit);
    }

    public static UIDefinition createAfterInit(final Consumer<UIAccessor> afterInit) {
        return new UIDefinition(){

            @Override
            public void afterInit(UIAccessor accessor) {
                afterInit.accept(accessor);
            }
        };
    }

    @Deprecated
    public static UIDefinition createAfterInit(String name, Consumer<UIAccessor> afterInit) {
        return UIDefinition.createAfterInit(afterInit);
    }

    public static UIDefinition createAfterInitWithAmount(String name, Consumer<UIAccessor> afterInit) {
        return UIDefinition.createAfterInit(a -> {
            Bearer<Integer> bearer = Bearer.of(0);
            a.putBearer(name + ".index", bearer);
            afterInit.accept((UIAccessor)a);
        });
    }

    public static UIDefinition createBeforeTick(final Consumer<UIAccessor> beforeTick) {
        return new UIDefinition(){

            @Override
            public void beforeTick(UIAccessor accessor) {
                beforeTick.accept(accessor);
            }
        };
    }

    public static UIDefinition createAfterTick(final Consumer<UIAccessor> afterTick) {
        return new UIDefinition(){

            @Override
            public void afterTick(UIAccessor accessor) {
                afterTick.accept(accessor);
            }
        };
    }

    @Override
    default public boolean test(UIAccessor accessor) {
        return true;
    }

    public static class Instance
    implements UIDefinition {
        private final String name;
        private final Predicate<UIAccessor> applyCondition;
        protected List<UIDefinition> definitions = new ArrayList<UIDefinition>();
        protected List<UIDefinition> staticDefinitions = new ArrayList<UIDefinition>();

        public Instance(String name, Predicate<UIAccessor> applyCondition) {
            this.name = name;
            this.applyCondition = applyCondition;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void beforeInit(UIAccessor accessor) {
            this.getDefinitions().clear();
            this.getDefinitions().addAll(this.getStaticDefinitions());
            UIDefinition.super.beforeInit(accessor);
        }

        @Override
        public boolean test(UIAccessor accessor) {
            return this.applyCondition.test(accessor);
        }

        @Override
        public List<UIDefinition> getStaticDefinitions() {
            return this.staticDefinitions;
        }

        @Override
        public List<UIDefinition> getDefinitions() {
            return this.definitions;
        }
    }
}

