/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.network;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.network.SecureExecutor;

public interface CommonNetwork {
    public static final Multimap<UUID, String> ENABLED_PLAYERS = HashMultimap.create();

    public static <T extends Payload> void sendToPlayer(class_3222 serverPlayer, T packetHandler) {
        CommonNetwork.sendToPlayer(serverPlayer, packetHandler, false);
    }

    public static <T extends Payload> void sendToPlayer(class_3222 serverPlayer, T payload, boolean bypassCheck) {
        if (!bypassCheck && !ENABLED_PLAYERS.get((Object)serverPlayer.method_5667()).contains(payload.identifier().location().method_12836())) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        payload.encode(buf);
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)payload.identifier().location(), (class_2540)buf);
    }

    public static <T extends Payload> void sendToPlayers(Collection<class_3222> serverPlayers, T payload, boolean bypassCheck) {
        serverPlayers.forEach(s -> CommonNetwork.sendToPlayer(s, payload, bypassCheck));
    }

    public static <T extends Payload> void sendToPlayers(Collection<class_3222> serverPlayers, T payload) {
        CommonNetwork.sendToPlayers(serverPlayers, payload, false);
    }

    public static <T extends Payload> void sendToServer(T payload) {
        CommonNetwork.sendToServer(payload, false);
    }

    public static <T extends Payload> void sendToServer(T payload, boolean bypassCheck) {
        if (!FactoryAPI.isClient() || !bypassCheck && !FactoryAPIClient.hasModOnServer(payload.identifier().location().method_12836())) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        payload.encode(buf);
        ClientPlayNetworking.send((class_2960)payload.identifier().location(), (class_2540)buf);
    }

    public static void encodeComponent(PlayBuf buf, class_2561 component) {
        ((class_2540)buf.get()).method_10805(component);
    }

    public static class_2561 decodeComponent(PlayBuf buf) {
        return ((class_2540)buf.get()).method_10808();
    }

    public static void encodeItemStack(PlayBuf buf, class_1799 stack) {
        ((class_2540)buf.get()).method_10793(stack);
    }

    public static class_1799 decodeItemStack(PlayBuf buf) {
        return ((class_2540)buf.get()).method_10819();
    }

    public static void encodeBuf(PlayBuf buf, PlayBuf toEncode) {
        ((class_2540)buf.get()).method_10804(((class_2540)toEncode.get()).readableBytes());
        ((class_2540)buf.get()).writeBytes((ByteBuf)toEncode.get());
    }

    public static PlayBuf decodeBuf(PlayBuf buf) {
        int readable = ((class_2540)buf.get()).method_10816();
        if (readable > 0) {
            return PlayBuf.fromBuf(new class_2540(((class_2540)buf.get()).readBytes(readable)));
        }
        return PlayBuf.create();
    }

    public static interface Payload {
        public void apply(Context var1);

        default public void applyClient() {
            this.apply(Context.createClientContext());
        }

        default public void applyServer(Supplier<class_1657> player) {
            this.apply(Context.createServerContext(player));
        }

        default public void applySided(boolean client, Supplier<class_1657> player) {
            if (client) {
                this.applyClient();
            } else {
                this.applyServer(player);
            }
        }

        public Identifier<? extends Payload> identifier();

        default public void encode(class_2540 buf) {
            this.encode(() -> buf);
        }

        public void encode(PlayBuf var1);

        public static interface Context {
            public SecureExecutor executor();

            public class_1657 player();

            default public MinecraftServer server() {
                return FactoryAPIPlatform.getEntityServer((class_1297)this.player());
            }

            public boolean isClient();

            public static Context createClientContext() {
                return Context.createContext(FactoryAPIClient.SECURE_EXECUTOR, FactoryAPIClient::getClientPlayer, true);
            }

            public static Context createServerContext(Supplier<class_1657> player) {
                return Context.createContext(FactoryAPI.SECURE_EXECUTOR, player, true);
            }

            public static Context createContext(final SecureExecutor executor, final Supplier<class_1657> playerSupplier, final boolean isClient) {
                return new Context(){

                    @Override
                    public SecureExecutor executor() {
                        return executor;
                    }

                    @Override
                    public class_1657 player() {
                        return (class_1657)playerSupplier.get();
                    }

                    @Override
                    public boolean isClient() {
                        return isClient;
                    }
                };
            }
        }
    }

    public static interface Identifier<T extends Payload> {
        public class_2960 location();

        public T decode(class_2540 var1);

        public static <T extends Payload> Identifier<T> create(class_2960 location, Supplier<T> decoder) {
            return Identifier.create(location, (PlayBuf b) -> (Payload)decoder.get());
        }

        public static <T extends Payload> Identifier<T> create(final class_2960 location, final Function<PlayBuf, T> decoder) {
            return new Identifier<T>(){

                @Override
                public class_2960 location() {
                    return location;
                }

                @Override
                public T decode(class_2540 buf) {
                    return (Payload)decoder.apply(() -> buf);
                }
            };
        }
    }

    public static interface PlayBuf
    extends Supplier<class_2540> {
        public static PlayBuf create() {
            return PlayBuf.fromBuf(new class_2540(Unpooled.buffer()));
        }

        public static PlayBuf of(class_2540 buf) {
            return () -> buf;
        }

        public static PlayBuf fromBuf(class_2540 buf) {
            return PlayBuf.of(buf);
        }
    }

    public static abstract class EmptyPayload
    implements Payload {
        private final Identifier<? extends Payload> identifier;

        public EmptyPayload(Identifier<? extends Payload> identifier) {
            this.identifier = identifier;
        }

        @Override
        public void encode(PlayBuf buf) {
        }

        @Override
        public Identifier<? extends Payload> identifier() {
            return this.identifier;
        }
    }
}

