/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.util.ListMap;

public class DynamicUtil {
    public static final ListMap<class_2960, ArbitrarySupplier<class_1799>> COMMON_ITEMS = new ListMap();
    public static final LoadingCache<Pair<Dynamic<?>, Boolean>, class_1799> DYNAMIC_ITEMS_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(pair -> ((Dynamic)pair.getFirst()).get("item").asString().result().or(() -> ((Dynamic)pair.getFirst()).asString().result()).map(s -> ((class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)s))).method_7854()).map(i -> {
        ((Dynamic)pair.getFirst()).get("count").result().flatMap(d1 -> Codec.INT.parse(d1).result()).ifPresent(arg_0 -> ((class_1799)i).method_7939(arg_0));
        if (((Boolean)pair.getSecond()).booleanValue()) {
            ((Dynamic)pair.getFirst()).get("nbt").result().flatMap(d1 -> class_2487.field_25128.parse(d1).result()).ifPresent(arg_0 -> ((class_1799)i).method_7980(arg_0));
        }
        return i;
    }).orElse(class_1799.field_8037)));
    public static final LoadingCache<DynamicOps<?>, class_6903<?>> REGISTRY_OPS_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(o -> class_6903.method_46632((DynamicOps)o, (class_7225.class_7874)FactoryAPIPlatform.getRegistryAccess())));
    public static final Codec<class_243> VEC3_OPTIONAL_CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.DOUBLE.fieldOf("x").orElse((Object)0.0).forGetter(class_243::method_10216), (App)Codec.DOUBLE.fieldOf("y").orElse((Object)0.0).forGetter(class_243::method_10214), (App)Codec.DOUBLE.fieldOf("z").orElse((Object)0.0).forGetter(class_243::method_10215)).apply((Applicative)i, class_243::new));
    public static final Codec<class_243> VEC3_OBJECT_CODEC = Codec.either(VEC3_OPTIONAL_CODEC, (Codec)class_243.field_38277).xmap(e -> (class_243)e.map(v -> v, v -> v), Either::right);
    public static final Codec<class_241> VEC2_OPTIONAL_CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("x").orElse((Object)Float.valueOf(0.0f)).forGetter(vec2 -> Float.valueOf(vec2.field_1343)), (App)Codec.FLOAT.fieldOf("y").orElse((Object)Float.valueOf(0.0f)).forGetter(vec2 -> Float.valueOf(vec2.field_1342))).apply((Applicative)i, class_241::new));
    public static final Codec<class_241> VEC2_CODEC = Codec.either(VEC2_OPTIONAL_CODEC, (Codec)Codec.FLOAT.listOf().comapFlatMap(list -> class_156.method_33141((List)list, (int)2).map(listx -> new class_241(((Float)listx.get(0)).floatValue(), ((Float)listx.get(1)).floatValue())), vec3 -> List.of(Float.valueOf(vec3.field_1343), Float.valueOf(vec3.field_1342)))).xmap(e -> (class_241)e.map(v -> v, v -> v), Either::right);
    public static final Codec<class_1799> COMPLETE_ITEM_CODEC = RecordCodecBuilder.create(i -> i.group((App)class_7923.field_41178.method_40294().fieldOf("item").forGetter(class_1799::method_41409), (App)Codec.INT.fieldOf("count").orElse((Object)1).forGetter(class_1799::method_7947), (App)class_2487.field_25128.optionalFieldOf("nbt").forGetter(itemStack -> Optional.ofNullable(itemStack.method_7969()))).apply((Applicative)i, (item, count, nbt) -> {
        class_1799 stack = new class_1799(item, count.intValue());
        stack.method_7980((class_2487)nbt.orElse(null));
        return stack;
    }));
    public static final Codec<class_1799> ITEM_CODEC = Codec.either((Codec)class_7923.field_41178.method_40294().xmap(class_1799::new, class_1799::method_41409), COMPLETE_ITEM_CODEC).xmap(e -> e.right().orElseGet(e.left()::get), Either::right);
    public static Codec<ArbitrarySupplier<class_1799>> ITEM_WITHOUT_DATA_SUPPLIER_CODEC = Codec.of((Encoder)ITEM_CODEC.xmap(ArbitrarySupplier::of, Supplier::get), DynamicUtil::getItemWithoutDataFromDynamic);
    public static Codec<ArbitrarySupplier<class_1799>> ITEM_SUPPLIER_CODEC = Codec.of((Encoder)ITEM_CODEC.xmap(ArbitrarySupplier::of, Supplier::get), DynamicUtil::getItemFromDynamic);

    public static <T> DataResult<Pair<ArbitrarySupplier<class_1799>, T>> getItemWithoutDataFromDynamic(DynamicOps<T> ops, T input) {
        return DynamicUtil.getItemFromDynamic(ops, input, false);
    }

    public static <T> DataResult<Pair<ArbitrarySupplier<class_1799>, T>> getItemFromDynamic(DynamicOps<T> ops, T input) {
        return DynamicUtil.getItemFromDynamic(ops, input, true);
    }

    public static <T> DataResult<Pair<ArbitrarySupplier<class_1799>, T>> getItemFromDynamic(DynamicOps<T> ops, T input, boolean allowData) {
        return DataResult.success((Object)Pair.of(DynamicUtil.getItemFromDynamic(new Dynamic(ops, input), allowData), input));
    }

    public static ArbitrarySupplier<class_1799> getItemFromDynamic(Dynamic<?> element, boolean allowData) {
        return element.get("common_item").asString().map(s -> COMMON_ITEMS.get(class_2960.method_12829((String)s))).result().orElseGet(() -> {
            Pair pair = Pair.of((Object)element, (Object)allowData);
            DYNAMIC_ITEMS_CACHE.refresh((Object)pair);
            return () -> (class_1799)DYNAMIC_ITEMS_CACHE.getUnchecked((Object)pair);
        });
    }

    public static <T> Dynamic<T> convertToRegistryIfPossible(Dynamic<T> dynamic) {
        return !(dynamic.getOps() instanceof class_6903) && (!FactoryAPI.isClient() || FactoryAPIClient.hasLevel()) ? dynamic.convert(DynamicUtil.getActualRegistryOps(dynamic.getOps())) : dynamic;
    }

    public static <T> DynamicOps<T> getActualRegistryOps(DynamicOps<T> ops) {
        return FactoryAPI.isClient() && !FactoryAPIClient.hasLevel() ? ops : (DynamicOps)REGISTRY_OPS_CACHE.getUnchecked(ops);
    }

    public static Codec<class_2561> getComponentCodec() {
        return class_5699.field_40722;
    }
}

