/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.util.CompoundTagUtil;

public class FluidInstance {
    private final class_3611 fluid;
    private int amount;
    private class_2487 tag;
    public static final Codec<FluidInstance> CODEC = RecordCodecBuilder.create((T i) -> i.group((App)class_7923.field_41173.method_39673().fieldOf("fluid").forGetter(FluidInstance::getFluid), (App)Codec.INT.fieldOf("amount").forGetter(FluidInstance::getAmount), (App)class_2487.field_25128.fieldOf("nbt").forGetter(FluidInstance::getNonNullTag)).apply((Applicative)i, FluidInstance::new));
    public static final FluidInstance EMPTY = new FluidInstance(class_3612.field_15906, 0);

    public FluidInstance(class_3611 fluid, int amount) {
        this.fluid = fluid;
        this.amount = amount;
    }

    public FluidInstance(class_3611 fluid, int amount, class_2487 tag) {
        this(fluid, amount);
        this.tag = tag.method_10553();
    }

    public static FluidInstance empty() {
        return EMPTY;
    }

    public static FluidInstance create(FluidInstance fluidInstance, int amount) {
        return FluidInstance.create(fluidInstance.getFluid(), amount);
    }

    public static FluidInstance create(class_3611 fluid, int amount) {
        return new FluidInstance(fluid, amount);
    }

    public static FluidInstance create(class_3611 fluid) {
        return new FluidInstance(fluid, 1000);
    }

    public static FluidInstance create(class_3611 fluid, long amount) {
        return new FluidInstance(fluid, FluidInstance.getMilliBucketsFluidAmount(amount));
    }

    public class_2487 getNonNullTag() {
        return this.getTag() == null ? new class_2487() : this.getTag();
    }

    public class_2487 getTag() {
        return this.tag;
    }

    public void setTag(class_2487 tag) {
        if (this.getFluid() != class_3612.field_15906) {
            this.tag = tag;
        }
    }

    public class_2487 getOrCreateTag() {
        if (this.tag == null) {
            this.setTag(new class_2487());
        }
        return this.tag;
    }

    public class_3611 getFluid() {
        return this.fluid;
    }

    public boolean isEmpty() {
        return this.getAmount() <= 0;
    }

    public int getAmount() {
        return this.getFluid() == class_3612.field_15906 ? 0 : this.amount;
    }

    public long getPlatformAmount() {
        return FluidInstance.getPlatformFluidAmount(this.getAmount());
    }

    public void setAmount(int amount) {
        if (this.getFluid() != class_3612.field_15906) {
            this.amount = amount;
        }
    }

    public FluidVariant toVariant() {
        return FluidVariant.of((class_3611)this.fluid, (class_2487)this.tag);
    }

    public void setAmount(long amount) {
        this.setAmount(FluidInstance.getMilliBucketsFluidAmount(amount));
    }

    public static FluidInstance fromJson(JsonObject jsonObject) {
        if (jsonObject != null) {
            return CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().orElse(FluidInstance.empty());
        }
        return FluidInstance.empty();
    }

    public static FluidInstance fromTag(class_2487 tag) {
        return CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag).result().orElseGet(() -> {
            Optional fluidId = CompoundTagUtil.getCompoundTag(tag, "fluidVariant").flatMap(c -> CompoundTagUtil.getString(c, "fluid"));
            if (fluidId.isPresent()) {
                class_3611 fluid = (class_3611)FactoryAPIPlatform.getRegistryValue(FactoryAPI.createLocation((String)fluidId.get()), class_7923.field_41173);
                if (fluid == class_3612.field_15906) {
                    return FluidInstance.empty();
                }
                return FluidInstance.create(fluid, FluidInstance.getMilliBucketsFluidAmount(CompoundTagUtil.getLong(tag, "amount").orElse(0L)));
            }
            return FluidInstance.empty();
        });
    }

    public static class_2487 toTag(FluidInstance stack) {
        return CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)stack).result().map(t -> {
            class_2487 c;
            return t instanceof class_2487 ? (c = (class_2487)t) : null;
        }).orElse(new class_2487());
    }

    public static long getPlatformBucketFluidAmount() {
        return FactoryAPI.getLoader().isFabric() ? 81000L : 1000L;
    }

    public static long getPlatformFluidAmount(int amount) {
        return (long)((float)amount / 1000.0f * (float)FluidInstance.getPlatformBucketFluidAmount());
    }

    public static int getMilliBucketsFluidAmount(long amount) {
        return (int)((float)amount / (float)FluidInstance.getPlatformBucketFluidAmount() * 1000.0f);
    }

    public boolean isFluidEqual(FluidInstance resource) {
        return this.getFluid() == resource.getFluid();
    }

    public void grow(int amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public void shrink(int amount) {
        this.setAmount(this.getAmount() - amount);
    }

    public FluidInstance withAmount(int amount) {
        this.setAmount(amount);
        return this;
    }

    public FluidInstance copy() {
        return new FluidInstance(this.getFluid(), this.getAmount());
    }

    public FluidInstance copyWithAmount(int maxDrain) {
        return this.copy().withAmount(maxDrain);
    }

    public class_2561 getName() {
        return this.getFluid().method_15785().method_15759().method_26204().method_9518();
    }

    public boolean equals(Object obj) {
        FluidInstance i;
        return super.equals(obj) || obj instanceof FluidInstance && (i = (FluidInstance)obj).isFluidEqual(this) && i.getAmount() == this.getAmount() && Objects.equals(this.tag, i.tag);
    }

    public int hashCode() {
        return Objects.hash(this.fluid, this.amount, this.tag);
    }

    public static void encode(class_2540 buf, FluidInstance instance) {
        buf.writeInt(instance.getAmount());
        if (instance.isEmpty()) {
            return;
        }
        buf.method_10812(class_7923.field_41173.method_10221((Object)instance.getFluid()));
        buf.method_10794(instance.getNonNullTag());
    }

    public static FluidInstance decode(class_2540 buf) {
        int amount = buf.readInt();
        if (amount <= 0) {
            return EMPTY;
        }
        return new FluidInstance((class_3611)FactoryAPIPlatform.getRegistryValue(buf.method_10810(), class_7923.field_41173), amount, buf.method_10798());
    }
}

