/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface ArbitrarySupplier<T>
extends Supplier<T> {
    public static final ArbitrarySupplier<?> EMPTY = () -> null;

    public static <T> ArbitrarySupplier<T> empty() {
        return EMPTY;
    }

    public static <T> ArbitrarySupplier<T> of(T object) {
        return () -> object;
    }

    default public <O> Object orObject(@NotNull O alternative) {
        return this.isPresent() ? this.get() : alternative;
    }

    default public T orElse(T alternative) {
        return this.isPresent() ? this.get() : alternative;
    }

    default public T or(@NotNull T alternative) {
        return this.or(() -> alternative).get();
    }

    default public ArbitrarySupplier<T> or(ArbitrarySupplier<@NotNull T> alternative) {
        return this.isPresent() ? this : alternative;
    }

    default public void ifPresent(Consumer<T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.get());
        }
    }

    default public void ifPresentAnd(Consumer<T> consumer, Predicate<T> predicate) {
        if (this.isPresent() && predicate.test(this.get())) {
            consumer.accept(this.get());
        }
    }

    default public void accept(Consumer<T> consumer, T alternative) {
        consumer.accept(this.isPresent() ? this.get() : alternative);
    }

    default public boolean isPresent() {
        return !this.isEmpty();
    }

    default public boolean isEmpty() {
        return this.get() == null;
    }

    default public boolean isPresentAnd(Predicate<T> predicate) {
        return this.isPresent() && predicate.test(this.get());
    }

    default public <U> ArbitrarySupplier<U> secureCast(Class<U> aimClass) {
        return this.map(o -> aimClass.isInstance(o) ? aimClass.cast(o) : null);
    }

    default public <U> ArbitrarySupplier<U> cast() {
        return this;
    }

    default public <U> ArbitrarySupplier<U> map(Function<T, U> mapping) {
        return this.isPresent() ? () -> mapping.apply(this.get()) : ArbitrarySupplier.empty();
    }

    default public <U> ArbitrarySupplier<U> flatMap(Function<T, ArbitrarySupplier<U>> mapping) {
        return this.isPresent() ? mapping.apply(this.get()) : ArbitrarySupplier.empty();
    }

    default public Optional<T> optional() {
        return Optional.ofNullable(this.get());
    }
}

