/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.mixin.base;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.WidgetAccessor;

@Mixin(value={AbstractWidget.class})
public abstract class AbstractWidgetMixin
implements WidgetAccessor,
GuiEventListener {
    @Shadow
    protected int height;
    @Shadow
    public boolean visible;
    @Unique
    ResourceLocation overrideSprite = null;
    @Unique
    ResourceLocation highlightedOverrideSprite = null;
    @Unique
    Consumer<AbstractWidget> onPressOverride = null;
    @Unique
    ArbitrarySupplier<Boolean> visibility = ArbitrarySupplier.empty();

    @Shadow
    public abstract boolean isHoveredOrFocused();

    @Override
    public void setSpriteOverride(ResourceLocation sprite) {
        this.overrideSprite = sprite;
    }

    @Override
    public void setHighlightedSpriteOverride(ResourceLocation sprite) {
        this.highlightedOverrideSprite = sprite;
    }

    @Override
    public ResourceLocation getSpriteOverride() {
        return this.isHoveredOrFocused() ? this.highlightedOverrideSprite : this.overrideSprite;
    }

    @Override
    public Consumer<AbstractWidget> getOnPressOverride() {
        return this.onPressOverride;
    }

    @Override
    public void setOnPressOverride(Consumer<AbstractWidget> onPressOverride) {
        this.onPressOverride = onPressOverride;
    }

    @Unique
    private void onPress() {
        if (this.getOnPressOverride() != null) {
            this.getOnPressOverride().accept((AbstractWidget)this);
        }
    }

    @Override
    public void setVisibility(ArbitrarySupplier<Boolean> supplier) {
        this.visibility = supplier;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void render(GuiGraphics arg, int i, int j, float f, CallbackInfo ci) {
        if (this.visibility.isPresent()) {
            this.visible = (Boolean)this.visibility.get();
        }
    }

    @Inject(method={"onClick"}, at={@At(value="HEAD")})
    public void onClick(double d, double e, CallbackInfo ci) {
        this.onPress();
    }
}

