/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.mixin.base;

import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.base.network.CommonNetwork;

@Mixin(value={Ingredient.class})
public abstract class IngredientMixin
implements FactoryIngredient {
    @Shadow
    @Final
    protected HolderSet<Item> values;
    @Mutable
    @Shadow
    @Final
    public static StreamCodec<RegistryFriendlyByteBuf, Optional<Ingredient>> OPTIONAL_CONTENTS_STREAM_CODEC;
    @Unique
    private ItemStack[] stacks;

    @Override
    public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
        return FactoryIngredient.DEFAULT_ID;
    }

    @Override
    public ItemStack[] getStacks() {
        return this.stacks == null ? (this.stacks = (ItemStack[])this.values.stream().map(ItemStack::new).toArray(ItemStack[]::new)) : this.stacks;
    }

    @Override
    public void encode(CommonNetwork.PlayBuf buf) {
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf.get()), (Object)((Ingredient)this));
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Redirect(method={"<clinit>"}, at=@At(value="FIELD", target="Lnet/minecraft/world/item/crafting/Ingredient;OPTIONAL_CONTENTS_STREAM_CODEC:Lnet/minecraft/network/codec/StreamCodec;"))
    private static void fixOptionalIngredientStreamCodec(StreamCodec<RegistryFriendlyByteBuf, Optional<Ingredient>> value) {
        OPTIONAL_CONTENTS_STREAM_CODEC = StreamCodec.of((b, o) -> b.writeOptional(o, (b1, i) -> Ingredient.CONTENTS_STREAM_CODEC.encode(b, i)), b -> b.readOptional(b1 -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(b)));
    }
}

