/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import java.util.AbstractList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import wily.factoryapi.base.Stocker;

public class PagedList<T>
extends AbstractList<T> {
    public final Stocker.Sizeable page;
    private final Supplier<Integer> maxPageSize;
    public T[] objects = new Object[0];

    public PagedList(Stocker.Sizeable page, int maxPageSize) {
        this(page, () -> maxPageSize);
    }

    public PagedList(Stocker.Sizeable page, Supplier<Integer> maxPageSize) {
        this.page = page;
        this.maxPageSize = maxPageSize;
    }

    public int allSize() {
        return this.objects.length;
    }

    @Override
    public int size() {
        return Math.min(this.maxPageSize.get(), this.allSize() - (Integer)this.page.get() * this.maxPageSize.get());
    }

    @Override
    public void add(int index, T element) {
        this.objects = ArrayUtils.insert((int)index, (Object[])this.objects, (Object[])new Object[]{element});
    }

    @Override
    public boolean add(T t) {
        if (!this.isEmpty() && this.allSize() % this.maxPageSize.get() == 0 && this.page.max <= this.allSize() / this.maxPageSize.get() - 1) {
            ++this.page.max;
        }
        this.add(this.allSize(), t);
        return true;
    }

    @Override
    public T get(int index) {
        return this.objects[(Integer)this.page.get() * this.maxPageSize.get() + index];
    }

    @Override
    public T remove(int index) {
        T r = this.objects[index];
        this.objects = ArrayUtils.remove((Object[])this.objects, (int)index);
        if (this.objects.length % this.maxPageSize.get() == this.maxPageSize.get() - 1) {
            --this.page.max;
        }
        return r;
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.objects.length; ++i) {
            if (this.objects[i] != o) continue;
            return i % this.maxPageSize.get();
        }
        return -1;
    }

    public static <T> int occurrenceOf(List<T> list, T object, int index) {
        int o = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (!object.equals(list.get(i))) continue;
            if (i == index) {
                return o;
            }
            ++o;
        }
        return -1;
    }

    public static <T> int indexOf(List<T> list, T object, int occurrence) {
        int o = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (object != list.get(i)) continue;
            if (o == occurrence) {
                return i;
            }
            ++o;
        }
        return -1;
    }
}

