/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_11580;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.ItemContainerPlatform;
import wily.factoryapi.base.FactoryFluidHandler;
import wily.factoryapi.base.IPlatformItemFluidHandler;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.init.FactoryRegistries;
import wily.factoryapi.util.CompoundTagUtil;
import wily.factoryapi.util.FluidInstance;

public class FactoryItemFluidHandler
extends FactoryFluidHandler
implements IPlatformItemFluidHandler {
    private final class_1799 container;

    public FactoryItemFluidHandler(int capacity, class_1799 container) {
        this(capacity, container, f -> true, TransportState.EXTRACT_INSERT);
    }

    public FactoryItemFluidHandler(int capacity, class_1799 stack, Predicate<FluidInstance> validator, TransportState transportState) {
        super(capacity, null, validator, SlotsIdentifier.GENERIC, transportState);
        this.container = stack;
    }

    public String getStorageKey() {
        return this.isBlockItem() ? "singleTank" : "fluidVariant";
    }

    public boolean isBlockItem() {
        return ItemContainerPlatform.isBlockItem(this.container);
    }

    @Override
    public void setFluid(FluidInstance fluid) {
        boolean b = this.isBlockItem();
        if (b) {
            int capacity = this.getMaxFluid();
            class_2487 beTag = this.container.method_57826(class_9334.field_49611) ? ((class_11580)this.container.method_58694(class_9334.field_49611)).method_72540() : new class_2487();
            class_2487 tag = FluidInstance.toTag(fluid);
            tag.method_10569("capacity", capacity);
            beTag.method_10566(this.getStorageKey(), (class_2520)tag);
            this.container.method_57379(class_9334.field_49611, (Object)class_11580.method_72535((Object)class_2591.field_11914, (class_2487)beTag));
        } else {
            this.container.method_57379((class_9331)FactoryRegistries.FLUID_INSTANCE_COMPONENT.get(), (Object)fluid);
        }
    }

    @Override
    @NotNull
    public FluidInstance getFluidInstance() {
        return this.isBlockItem() ? FactoryItemFluidHandler.getFromComponentOrDefault(this.container, class_9334.field_49611, class_11580::method_72540, c -> FluidInstance.fromTag(CompoundTagUtil.getCompoundTagOrEmpty(c, this.getStorageKey())), c -> c.method_10545(this.getStorageKey()), FluidInstance.empty()) : (FluidInstance)this.container.method_58695((class_9331)FactoryRegistries.FLUID_INSTANCE_COMPONENT.get(), (Object)FluidInstance.empty());
    }

    public static <C, D, T> T getFromComponentOrDefault(class_1799 stack, class_9331<C> type, Function<C, D> getter, Function<D, T> mapper, Predicate<D> allow, T obj) {
        D d;
        return !stack.method_57826(type) || !allow.test(d = getter.apply(stack.method_58694(type))) ? obj : mapper.apply(d);
    }

    @Override
    public int fill(FluidInstance resource, boolean simulate) {
        if (this.container.method_7947() != 1 || resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        FluidInstance contained = this.getFluidInstance().copy();
        if (contained.isEmpty()) {
            int fillAmount = Math.min(this.getMaxFluid(), resource.getAmount());
            if (!simulate) {
                FluidInstance filled = resource.copy();
                filled.setAmount(fillAmount);
                this.setFluid(filled);
            }
            return fillAmount;
        }
        if (contained.isFluidEqual(resource)) {
            int fillAmount = Math.min(this.getMaxFluid() - contained.getAmount(), resource.getAmount());
            if (!simulate && fillAmount > 0) {
                contained.grow(fillAmount);
                this.setFluid(contained);
            }
            return fillAmount;
        }
        return 0;
    }

    @Override
    @NotNull
    public FluidInstance drain(int maxDrain, boolean simulate) {
        if (this.container.method_7947() != 1 || maxDrain <= 0 || !this.getTransport().canExtract()) {
            return FluidInstance.empty();
        }
        FluidInstance contained = this.getFluidInstance().copy();
        if (contained.isEmpty()) {
            return FluidInstance.empty();
        }
        int drainAmount = Math.min(contained.getAmount(), maxDrain);
        FluidInstance drained = contained.copy();
        drained.setAmount(drainAmount);
        if (!simulate) {
            contained.shrink(drainAmount);
            if (contained.isEmpty()) {
                this.setContainerToEmpty();
            } else {
                this.setFluid(contained);
            }
        }
        return drained;
    }

    protected void setContainerToEmpty() {
        this.container.method_57381((class_9331)FactoryRegistries.FLUID_INSTANCE_COMPONENT.get());
        this.container.method_57381((class_9331)FactoryRegistries.FLUID_CAPACITY_COMPONENT.get());
    }

    @Override
    public void setCapacity(int capacity) {
        boolean b = this.isBlockItem();
        if (b) {
            class_2487 beTag = this.container.method_57826(class_9334.field_49611) ? ((class_11580)this.container.method_58694(class_9334.field_49611)).method_72540() : new class_2487();
            class_2487 tag = CompoundTagUtil.getCompoundTagOrEmpty(beTag, this.getStorageKey());
            tag.method_10569("capacity", capacity);
            beTag.method_10566(this.getStorageKey(), (class_2520)tag);
            this.container.method_57379(class_9334.field_49611, (Object)class_11580.method_72535((Object)class_2591.field_11914, (class_2487)beTag));
        } else {
            this.container.method_57379((class_9331)FactoryRegistries.FLUID_CAPACITY_COMPONENT.get(), (Object)capacity);
        }
    }

    @Override
    public int getMaxFluid() {
        return this.isBlockItem() ? FactoryItemFluidHandler.getFromComponentOrDefault(this.container, class_9334.field_49611, class_11580::method_72540, c -> CompoundTagUtil.getInt(c, this.getStorageKey()).orElse(0), c -> c.method_10545(this.getStorageKey()), super.getMaxFluid()).intValue() : ((Integer)this.container.method_58695((class_9331)FactoryRegistries.FLUID_CAPACITY_COMPONENT.get(), (Object)super.getMaxFluid())).intValue();
    }

    @Override
    public class_1799 getContainer() {
        return this.container;
    }
}

