/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.BlockSide;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.FactoryStorage;
import wily.factoryapi.base.IFactoryStorage;
import wily.factoryapi.base.IHasIdentifier;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.SideList;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportSide;
import wily.factoryapi.util.CompoundTagUtil;

public interface IFactoryExpandedStorage
extends IFactoryStorage {
    default public void replaceSidedStorage(BlockSide blockSide, SideList<TransportSide> side, TransportSide replacement) {
        IFactoryExpandedStorage iFactoryExpandedStorage = this;
        if (iFactoryExpandedStorage instanceof class_2586) {
            class_2586 be = (class_2586)iFactoryExpandedStorage;
            side.put(blockSide.blockStateToFacing(be.method_11010()), replacement);
        }
    }

    default public class_2371<FactoryItemSlot> getSlots(@Nullable class_1657 player) {
        return class_2371.method_10211();
    }

    default public List<IPlatformFluidHandler> getTanks() {
        return Collections.emptyList();
    }

    default public Map<SlotsIdentifier, int[]> itemSlotsIdentifiers() {
        LinkedHashMap<SlotsIdentifier, int[]> map = new LinkedHashMap<SlotsIdentifier, int[]>();
        for (FactoryItemSlot slot : this.getSlots(null)) {
            int[] list = map.getOrDefault(slot.identifier(), new int[0]);
            if (ArrayUtils.contains((int[])list, (int)slot.method_34266())) continue;
            list = ArrayUtils.add((int[])list, (int)slot.method_34266());
            map.put(slot.identifier(), list);
        }
        return map;
    }

    default public List<class_2350> getBlockedSides() {
        return Collections.emptyList();
    }

    default public List<SlotsIdentifier> getItemSlotsIdentifiers() {
        return List.copyOf(this.itemSlotsIdentifiers().keySet());
    }

    default public List<SlotsIdentifier> getFluidSlotsIdentifiers() {
        return IHasIdentifier.getSlotsIdentifiers(this.getTanks());
    }

    default public void loadTag(class_2487 compoundTag) {
        this.getStorage(FactoryStorage.CRAFTY_ENERGY).ifPresent(e -> e.deserializeTag(CompoundTagUtil.getCompoundTagOrEmpty(compoundTag, "CYEnergy")));
        this.getStorage(FactoryStorage.ENERGY).ifPresent(e -> e.deserializeTag(CompoundTagUtil.getCompoundTagOrEmpty(compoundTag, "Energy")));
        if (!this.getTanks().isEmpty()) {
            this.getTanks().forEach(tank -> tank.deserializeTag(CompoundTagUtil.getCompoundTagOrEmpty(compoundTag, tank.getName())));
        }
        this.getStorage(FactoryStorage.ITEM).ifPresent(e -> e.deserializeTag((class_2520)CompoundTagUtil.getCompoundTagOrEmpty(compoundTag, "inventory")));
        this.getStorageSides(FactoryStorage.FLUID).ifPresent(f -> TransportSide.deserializeTag(CompoundTagUtil.getCompoundTagOrEmpty(compoundTag, "fluidSides"), f, this.getTanks()));
        this.getStorageSides(FactoryStorage.ITEM).ifPresent(i -> TransportSide.deserializeTag(CompoundTagUtil.getCompoundTagOrEmpty(compoundTag, "itemSides"), i, this.getItemSlotsIdentifiers()));
        this.getStorageSides(FactoryStorage.CRAFTY_ENERGY).ifPresent(e -> TransportSide.deserializeTag(CompoundTagUtil.getCompoundTagOrEmpty(compoundTag, "energySides"), e));
    }

    default public void saveTag(class_2487 compoundTag) {
        this.getStorage(FactoryStorage.CRAFTY_ENERGY).ifPresent(e -> compoundTag.method_10566("CYEnergy", e.serializeTag()));
        this.getStorage(FactoryStorage.ENERGY).ifPresent(e -> compoundTag.method_10566("Energy", e.serializeTag()));
        if (!this.getTanks().isEmpty()) {
            this.getTanks().forEach(tank -> compoundTag.method_10566(tank.getName(), (class_2520)tank.serializeTag()));
        }
        this.getStorage(FactoryStorage.ITEM).ifPresent(i -> compoundTag.method_10566("inventory", i.serializeTag()));
        this.getStorageSides(FactoryStorage.FLUID).ifPresent(f -> compoundTag.method_10566("fluidSides", (class_2520)TransportSide.serializeTag(f, this.getTanks())));
        this.getStorageSides(FactoryStorage.ITEM).ifPresent(i -> compoundTag.method_10566("itemSides", (class_2520)TransportSide.serializeTag(i, this.getItemSlotsIdentifiers())));
        this.getStorageSides(FactoryStorage.CRAFTY_ENERGY).ifPresent(e -> compoundTag.method_10566("energySides", (class_2520)TransportSide.serializeTag(e)));
    }
}

