/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ICraftyEnergyStorage;
import wily.factoryapi.base.IPlatformEnergyStorage;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.util.FluidInstance;

public class StorageStringUtil {
    public static final String DEFAULT_CRAFTY_ENERGY = "tooltip.factory_api.crafty_energy";
    public static final String DEFAULT_ENERGY_SUFFIX = StorageStringUtil.getBetweenParenthesis(FactoryAPIPlatform.getPlatformEnergyComponent().getString());
    public static final String DEFAULT_FLUID = "tooltip.factory_api.fluid";
    protected static String fluidMeasure = class_1074.method_4662((String)"tooltip.factory_api.fluid", (Object[])new Object[]{" "});
    protected static String milliFluid = class_1074.method_4662((String)"tooltip.factory_api.fluid", (Object[])new Object[]{" m"});
    protected static String kiloFluid = class_1074.method_4662((String)"tooltip.factory_api.fluid", (Object[])new Object[]{" k"});
    public static String energyMeasure = " " + DEFAULT_ENERGY_SUFFIX;
    public static String kiloEnergy = " k" + DEFAULT_ENERGY_SUFFIX;
    public static String megaEnergy = " M" + DEFAULT_ENERGY_SUFFIX;
    public static String CYMeasure = class_1074.method_4662((String)"tooltip.factory_api.crafty_energy", (Object[])new Object[]{" "});
    public static String kiloCY = class_1074.method_4662((String)"tooltip.factory_api.crafty_energy", (Object[])new Object[]{" k"});
    public static String megaCY = class_1074.method_4662((String)"tooltip.factory_api.crafty_energy", (Object[])new Object[]{" M"});

    public static class_5250 getEnergyTooltip(String key, IPlatformEnergyStorage cell) {
        return StorageStringUtil.getEnergyTooltip(key, cell, energyMeasure, kiloEnergy, megaEnergy);
    }

    public static class_5250 getEnergyTooltip(String key, ICraftyEnergyStorage cell) {
        return StorageStringUtil.getEnergyTooltip(key, cell, CYMeasure, kiloCY, megaCY);
    }

    public static class_5250 getEnergyTooltip(String key, IPlatformEnergyStorage cell, String ... measures) {
        return class_2561.method_43469((String)key, (Object[])new Object[]{StorageStringUtil.getStorageAmount(cell.getEnergyStored(), StorageStringUtil.isShiftKeyDown(), measures), StorageStringUtil.getStorageAmount(cell.getMaxEnergyStored(), false, measures)}).method_27696(cell.getComponentStyle());
    }

    public static class_5250 getMaxCraftyTransferTooltip(int energyPerTick) {
        return class_2561.method_43469((String)"tooltip.factory_api.max_transfer", (Object[])new Object[]{StorageStringUtil.getStorageAmount(energyPerTick, StorageStringUtil.isShiftKeyDown(), CYMeasure, kiloCY, megaCY)});
    }

    public static class_5250 getMaxEnergyTransferTooltip(int energyPerTick) {
        return class_2561.method_43469((String)"tooltip.factory_api.max_transfer", (Object[])new Object[]{StorageStringUtil.getStorageAmount(energyPerTick, StorageStringUtil.isShiftKeyDown(), energyMeasure, kiloEnergy, megaEnergy)}).method_27692(class_124.field_1075);
    }

    public static class_5250 getMaxFluidTransferTooltip(long fluidPerTick) {
        return class_2561.method_43469((String)"tooltip.factory_api.max_transfer", (Object[])new Object[]{StorageStringUtil.getStorageAmount(fluidPerTick, StorageStringUtil.isShiftKeyDown(), milliFluid, fluidMeasure, kiloFluid)}).method_27692(class_124.field_1080);
    }

    public static List<class_2561> getCompleteEnergyTooltip(String key, @Nullable class_2561 burned, ICraftyEnergyStorage cell) {
        ArrayList<class_2561> list = new ArrayList<class_2561>(List.of());
        if (burned == null || !cell.getStoredTier().isBurned()) {
            list.add((class_2561)StorageStringUtil.getEnergyTooltip(key, cell));
        } else {
            list.add((class_2561)burned.method_27661().method_27692(class_124.field_1079));
        }
        list.add((class_2561)cell.getStoredTier().getEnergyTierComponent(true));
        if (StorageStringUtil.isShiftKeyDown()) {
            list.add((class_2561)cell.getSupportedTier().getEnergyTierComponent(false));
        }
        return list;
    }

    public static List<class_2561> getCompleteEnergyTooltip(String key, ICraftyEnergyStorage cell) {
        return StorageStringUtil.getCompleteEnergyTooltip(key, null, cell);
    }

    public static class_2561 getFluidTooltip(String key, IPlatformFluidHandler tank) {
        return StorageStringUtil.getFluidTooltip(key, tank, true);
    }

    public static class_2561 getFluidTooltip(String key, IPlatformFluidHandler tank, boolean showEmpty) {
        return StorageStringUtil.getFluidTooltip(key, tank.getFluidInstance(), tank.getMaxFluid(), showEmpty).method_27692(tank.identifier().color());
    }

    public static class_5250 getFluidTooltip(String key, FluidInstance instance, long maxFluid, boolean showEmpty) {
        if (instance.isEmpty() && !StorageStringUtil.isShiftKeyDown() && showEmpty) {
            return class_2561.method_43471((String)"tooltip.factory_api.empty").method_27692(class_124.field_1080);
        }
        return class_2561.method_43469((String)key, (Object[])new Object[]{instance.getName(), StorageStringUtil.getStorageAmount(instance.getAmount(), StorageStringUtil.isShiftKeyDown(), milliFluid, fluidMeasure, kiloFluid), StorageStringUtil.getStorageAmount(maxFluid, false, milliFluid, fluidMeasure, kiloFluid)});
    }

    public static String getStorageAmount(long content, boolean additionalBool, String ... measures) {
        if (content == Integer.MAX_VALUE) {
            return "\u221e";
        }
        Object amount = "";
        for (int i = measures.length - 1; i >= 1; --i) {
            float min = (float)Math.pow(1000.0, i);
            if (!((float)content >= min)) continue;
            amount = StorageStringUtil.formatMinAmount((float)content / min) + measures[i];
            break;
        }
        if (additionalBool || content < 1000L) {
            amount = StorageStringUtil.formatAmount(content) + measures[0];
        }
        return amount;
    }

    public static String formatAmount(long i) {
        return String.format("%,d", i).replace(',', '.');
    }

    public static String formatMinAmount(float i) {
        return new DecimalFormat("0.####").format(Float.parseFloat(String.format(Locale.US, "%.1f", Float.valueOf(i))));
    }

    public static String getBetweenParenthesis(String name) {
        String[] s = name.split(" ");
        return s[s.length - 1].replaceAll("[()]", "");
    }

    public static boolean isShiftKeyDown() {
        return StorageStringUtil.isKeyDown(340) || StorageStringUtil.isKeyDown(344);
    }

    public static boolean isKeyDown(int glfw) {
        class_3675.class_306 key = class_3675.class_307.field_1668.method_1447(glfw);
        int keyCode = key.method_1444();
        if (keyCode != class_3675.field_16237.method_1444()) {
            try {
                if (key.method_1442() == class_3675.class_307.field_1668) {
                    return class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)keyCode);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

