/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.Collections;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.FuelValues;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.mixin.base.FuelValuesAccessor;

public class FuelManager {
    public static int getBurnTime(Item item) {
        return FuelManager.getBurnTime(item.getDefaultInstance());
    }

    public static Map<Item, Integer> getMap() {
        FuelValues fuelValues = FuelManager.getFuelValues();
        return fuelValues == null ? Collections.emptyMap() : ((FuelValuesAccessor)fuelValues).getValues();
    }

    public static FuelValues getFuelValues() {
        return FactoryAPI.currentServer == null ? (FactoryAPIClient.hasLevel() ? FactoryAPIClient.getLevel().fuelValues() : null) : FactoryAPI.currentServer.fuelValues();
    }

    public static int getBurnTime(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        return stack.getBurnTime(null, FuelManager.getFuelValues());
    }

    public static boolean isFuel(Item item) {
        return FuelManager.getBurnTime(item) > 0;
    }

    public static boolean isFuel(ItemStack stack) {
        return FuelManager.isFuel(stack.getItem());
    }

    public static void add(Item item, int burnTime) {
        FactoryAPIPlatform.getForgeEventBus().addListener(EventPriority.NORMAL, false, FurnaceFuelBurnTimeEvent.class, e -> {
            if (e.getItemStack().is(item)) {
                e.setBurnTime(burnTime);
            }
        });
    }
}

