/*
 * Decompiled with CFR 0.152.
 */
package com.teufel.statusmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.teufel.statusmod.StatusMod;
import com.teufel.statusmod.storage.PlayerSettings;
import com.teufel.statusmod.util.ColorMapper;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class StatusCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"status").then(class_2170.method_9247((String)"clear").executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            StatusCommand.clearStatus(src);
            return 1;
        }))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"status", (ArgumentType)StringArgumentType.greedyString()).then(class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            String status = StringArgumentType.getString((CommandContext)ctx, (String)"status");
            String color = StringArgumentType.getString((CommandContext)ctx, (String)"color");
            StatusCommand.setStatus(src, status, color);
            return 1;
        }))).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            String status = StringArgumentType.getString((CommandContext)ctx, (String)"status");
            StatusCommand.setStatus(src, status, "reset");
            return 1;
        })));
    }

    private static void setStatus(class_2168 src, String status, String colorKey) {
        try {
            int n;
            class_3222 player = src.method_44023();
            String uuid = player.method_72498().comp_4422().toString();
            PlayerSettings settings = StatusMod.storage.forPlayer(uuid);
            int n2 = n = settings.statusWords <= 0 ? 1 : settings.statusWords;
            if (colorKey == null || "reset".equalsIgnoreCase(colorKey)) {
                String[] stringArray = tokens = status == null ? new String[]{} : status.trim().split("\\s+");
                if (tokens.length < n) {
                    src.method_9213((class_2561)class_2561.method_43470((String)("Bitte mindestens " + n + " W\u00f6rter f\u00fcr den Status angeben.")));
                    return;
                }
                colorKey = tokens.length > n ? tokens[n] : "reset";
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        sb.append(' ');
                    }
                    sb.append(tokens[i]);
                }
                status = sb.toString();
            } else {
                String[] stringArray = tokens = status == null ? new String[]{} : status.trim().split("\\s+");
                if (tokens.length < n) {
                    src.method_9213((class_2561)class_2561.method_43470((String)("Bitte mindestens " + n + " W\u00f6rter f\u00fcr den Status angeben.")));
                    return;
                }
            }
            settings.status = status;
            settings.color = colorKey;
            StatusMod.storage.put(uuid, settings);
            String finalStatus = status;
            String finalColor = colorKey;
            MinecraftServer server = src.method_9211();
            class_2995 scoreboard = server.method_3845();
            String teamName = "status_" + uuid.substring(0, 8);
            class_268 team = scoreboard.method_1153(teamName);
            if (team == null) {
                team = scoreboard.method_1171(teamName);
            }
            class_124 f = ColorMapper.get(finalColor);
            class_5250 base = class_2561.method_43470((String)((settings.brackets ? "[" : "") + finalStatus + (settings.brackets ? "]" : "")));
            class_5250 colored = base.method_27661().method_27694(s -> s.method_10977(f == null ? class_124.field_1070 : f));
            if (settings.beforeName) {
                team.method_1138((class_2561)colored.method_27661().method_10852((class_2561)class_2561.method_43470((String)" ")));
                team.method_1139((class_2561)class_2561.method_43473());
            } else {
                team.method_1138((class_2561)class_2561.method_43473());
                team.method_1139((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)colored));
            }
            String playerName = player.method_5820();
            scoreboard.method_1157(playerName, team);
            scoreboard.method_1172(playerName, team);
            src.method_9226(() -> class_2561.method_43470((String)("Status gesetzt: " + finalStatus + " (" + finalColor + ")")), false);
        }
        catch (Exception e) {
            try {
                src.method_9213((class_2561)class_2561.method_43470((String)"Fehler beim Setzen des Status."));
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
        }
    }

    private static void clearStatus(class_2168 src) {
        try {
            class_3222 player = src.method_44023();
            String uuid = player.method_72498().comp_4422().toString();
            PlayerSettings settings = StatusMod.storage.forPlayer(uuid);
            settings.status = "";
            settings.color = "reset";
            StatusMod.storage.put(uuid, settings);
            MinecraftServer server = src.method_9211();
            class_2995 scoreboard = server.method_3845();
            String teamName = "status_" + uuid.substring(0, 8);
            class_268 team = scoreboard.method_1153(teamName);
            if (team != null) {
                String playerName = player.method_5820();
                scoreboard.method_1157(playerName, team);
                if (team.method_1204().isEmpty()) {
                    scoreboard.method_1191(team);
                }
            }
            src.method_9226(() -> class_2561.method_43470((String)"Status gel\u00f6scht."), false);
        }
        catch (Exception e) {
            try {
                src.method_9213((class_2561)class_2561.method_43470((String)"Fehler beim L\u00f6schen des Status."));
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
        }
    }
}

