/*
 * Decompiled with CFR 0.152.
 */
package com.teufel.statusmod.storage;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.teufel.statusmod.storage.PlayerSettings;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;

public class SettingsStorage {
    private final File file;
    private Map<String, PlayerSettings> map = new HashMap<String, PlayerSettings>();
    private final Gson gson = new Gson();

    public SettingsStorage() {
        File configDir = new File("config/statusmod");
        configDir.mkdirs();
        this.file = new File(configDir, "players.json");
        this.load();
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.save());
    }

    public synchronized PlayerSettings forPlayer(String uuid) {
        PlayerSettings s = this.map.get(uuid);
        if (s == null) {
            s = new PlayerSettings();
            this.map.put(uuid, s);
            this.save();
        }
        return s;
    }

    public synchronized void put(String uuid, PlayerSettings s) {
        this.map.put(uuid, s);
        this.save();
    }

    public synchronized void load() {
        try {
            if (!this.file.exists()) {
                return;
            }
            Type t = new TypeToken<Map<String, PlayerSettings>>(this){}.getType();
            FileReader fr = new FileReader(this.file);
            this.map = (Map)this.gson.fromJson((Reader)fr, t);
            if (this.map == null) {
                this.map = new HashMap<String, PlayerSettings>();
            }
            fr.close();
            boolean migrated = false;
            for (Map.Entry<String, PlayerSettings> e : this.map.entrySet()) {
                PlayerSettings ps = e.getValue();
                if (ps == null) continue;
                if (ps.statusWords <= 0) {
                    ps.statusWords = 1;
                    migrated = true;
                }
                if (ps.status == null) {
                    ps.status = "";
                }
                if (ps.color != null && !ps.color.isEmpty()) continue;
                ps.color = "reset";
            }
            if (migrated) {
                this.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void save() {
        try {
            File parent = this.file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            if (this.map == null) {
                this.map = new HashMap<String, PlayerSettings>();
            }
            FileWriter fw = new FileWriter(this.file);
            this.gson.toJson(this.map, (Appendable)fw);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

