package com.teufel.statusmod.command;

import com.teufel.statusmod.StatusMod;
import com.teufel.statusmod.storage.PlayerSettings;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.CommandDispatcher;

public class SettingsCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
    dispatcher.register(class_2170.method_9247("settings")
        .then(class_2170.method_9247("brackets")
            .then(class_2170.method_9244("value", StringArgumentType.word())
                .executes(ctx -> {
                    class_3222 p = ctx.getSource().method_44023();
                    String v = StringArgumentType.getString(ctx, "value");
                    boolean b = v.equalsIgnoreCase("on") || v.equalsIgnoreCase("true") || v.equalsIgnoreCase("ein") || v.equalsIgnoreCase("an");
                    toggleBrackets(p, b);
                    return 1;
                })
            )
        )
        .then(class_2170.method_9247("position")
            .then(class_2170.method_9244("value", StringArgumentType.word())
                .executes(ctx -> {
                                class_3222 p = ctx.getSource().method_44023();
                    String v = StringArgumentType.getString(ctx, "value");
                    boolean before = v.equalsIgnoreCase("before") || v.equalsIgnoreCase("vor") || v.equalsIgnoreCase("vorn");
                    setPosition(p, before);
                    return 1;
                })
            )
        )
    );
    }

    private static void toggleBrackets(class_3222 p, boolean value) {
    String uuid = p.method_72498().comp_4422().toString();
        PlayerSettings s = StatusMod.storage.forPlayer(uuid);
        s.brackets = value;
        StatusMod.storage.put(uuid, s);
        p.method_7353(class_2561.method_43470("Eckige Klammern: " + (value ? "AN" : "AUS")), false);
        applyStatusToTeam(p, s);
    }

    private static void setPosition(class_3222 p, boolean before) {
    String uuid = p.method_72498().comp_4422().toString();
        PlayerSettings s = StatusMod.storage.forPlayer(uuid);
        s.beforeName = before;
        StatusMod.storage.put(uuid, s);
        p.method_7353(class_2561.method_43470("Position: " + (before ? "vor dem Namen" : "hinter dem Namen")), false);
        applyStatusToTeam(p, s);
    }

    private static void applyStatusToTeam(class_3222 p, PlayerSettings s) {
        try {
            MinecraftServer server = p.method_51469().method_8503();
            net.minecraft.class_2995 scoreboard = server.method_3845();
            String teamName = "status_" + p.method_72498().comp_4422().toString().substring(0, 8);
            net.minecraft.class_268 team = scoreboard.method_1153(teamName);
            if (team == null) team = scoreboard.method_1171(teamName);

            net.minecraft.class_2561 base = net.minecraft.class_2561.method_43470((s.brackets ? "[" : "") + s.status + (s.brackets ? "]" : ""));
            net.minecraft.class_124 f = com.teufel.statusmod.util.ColorMapper.get(s.color);
            net.minecraft.class_2561 colored = base.method_27661().method_27694(st -> st.method_10977(f == null ? net.minecraft.class_124.field_1070 : f));

            if (s.beforeName) {
                team.method_1138(colored.method_27661().method_10852(net.minecraft.class_2561.method_43470(" ")));
                team.method_1139(net.minecraft.class_2561.method_43473());
            } else {
                team.method_1138(net.minecraft.class_2561.method_43473());
                team.method_1139(net.minecraft.class_2561.method_43470(" ").method_10852(colored));
            }
            scoreboard.method_1172(p.method_5820(), team);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
