package com.teufel.statusmod.command;

import com.teufel.statusmod.StatusMod;
import com.teufel.statusmod.storage.PlayerSettings;
import com.teufel.statusmod.util.ColorMapper;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;



public class StatusCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(class_2170.method_9247("status")
                .then(class_2170.method_9244("status", StringArgumentType.greedyString())
                        .then(class_2170.method_9244("color", StringArgumentType.word())
                                .executes(ctx -> {
                                    class_2168 src = ctx.getSource();
                                    String status = StringArgumentType.getString(ctx, "status");
                                    String color = StringArgumentType.getString(ctx, "color");
                                    setStatus(src, status, color);
                                    return 1;
                                })
                        )
                        .executes(ctx -> {
                            class_2168 src = ctx.getSource();
                            String status = StringArgumentType.getString(ctx, "status");
                            setStatus(src, status, "reset");
                            return 1;
                        })
                )
        );
    }

    private static void setStatus(class_2168 src, String status, String colorKey) {
        try {
            class_3222 player = src.method_44023();
            String uuid = player.method_72498().comp_4422().toString();

            PlayerSettings settings = StatusMod.storage.forPlayer(uuid);
            settings.status = status;
            settings.color = colorKey;
            StatusMod.storage.put(uuid, settings);

            MinecraftServer server = src.method_9211();
            net.minecraft.class_2995 scoreboard = server.method_3845();
            String teamName = "status_" + uuid.substring(0, 8);
            class_268 team = scoreboard.method_1153(teamName);
            if (team == null) team = scoreboard.method_1171(teamName);

            class_124 f = ColorMapper.get(colorKey);
            class_2561 base = class_2561.method_43470((settings.brackets ? "[" : "") + status + (settings.brackets ? "]" : ""));
            class_2561 colored = base.method_27661().method_27694(s -> s.method_10977(f == null ? class_124.field_1070 : f));

            if (settings.beforeName) {
                // prefix should have trailing space to separate from name
                team.method_1138(colored.method_27661().method_10852(class_2561.method_43470(" ")));
                team.method_1139(class_2561.method_43473());
            } else {
                // suffix should have leading space to separate from name
                team.method_1138(class_2561.method_43473());
                team.method_1139(class_2561.method_43470(" ").method_10852(colored));
            }

            // add player to team (applies prefix/suffix)
            String playerName = player.method_5820();
            scoreboard.method_1157(playerName, team); // safe
            scoreboard.method_1172(playerName, team);

            src.method_9226(() -> class_2561.method_43470("Status gesetzt: " + status + " (" + colorKey + ")"), false);
        } catch (Exception e) {
            try { src.method_9213(class_2561.method_43470("Fehler beim Setzen des Status.")); } catch(Exception ignore){}
            e.printStackTrace();
        }
    }
}
