/*
 * Decompiled with CFR 0.152.
 */
package com.teufel.statusmod.storage;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.teufel.statusmod.storage.PlayerSettings;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;

public class SettingsStorage {
    private final File file;
    private Map<String, PlayerSettings> map = new HashMap<String, PlayerSettings>();
    private final Gson gson = new Gson();

    public SettingsStorage() {
        File configDir = new File("config/statusmod");
        configDir.mkdirs();
        this.file = new File(configDir, "players.json");
        this.load();
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.save());
    }

    public synchronized PlayerSettings forPlayer(String uuid) {
        return this.map.computeIfAbsent(uuid, k -> new PlayerSettings());
    }

    public synchronized void put(String uuid, PlayerSettings s) {
        this.map.put(uuid, s);
        this.save();
    }

    public synchronized void load() {
        try {
            if (!this.file.exists()) {
                return;
            }
            Type t = new TypeToken<Map<String, PlayerSettings>>(this){}.getType();
            FileReader fr = new FileReader(this.file);
            this.map = (Map)this.gson.fromJson((Reader)fr, t);
            fr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void save() {
        try {
            FileWriter fw = new FileWriter(this.file);
            this.gson.toJson(this.map, (Appendable)fw);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

