/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFBungeeUtil;
import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.BungeeCommandCompletionContext;
import co.aikar.commands.CommandCompletions;
import co.aikar.commands.CommandManager;
import co.aikar.commands.apachecommonslang.ApacheCommonsLangUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class BungeeCommandCompletions
extends CommandCompletions<BungeeCommandCompletionContext> {
    public BungeeCommandCompletions(CommandManager manager) {
        super(manager);
        this.registerAsyncCompletion("chatcolors", c -> {
            String filter;
            Stream<ChatColor> colors = Stream.of(ChatColor.values());
            if (c.hasConfig("colorsonly")) {
                colors = colors.filter(color -> color.ordinal() <= 15);
            }
            if ((filter = c.getConfig("filter")) != null) {
                Set filters = Arrays.stream(ACFPatterns.COLON.split(filter)).map(ACFUtil::simplifyString).collect(Collectors.toSet());
                colors = colors.filter(color -> filters.contains(ACFUtil.simplifyString(color.name())));
            }
            return colors.map(color -> ACFUtil.simplifyString(color.name())).collect(Collectors.toList());
        });
        this.registerCompletion("players", c -> {
            CommandSender sender = c.getSender();
            ACFBungeeUtil.validate(sender, "Sender cannot be null", new Object[0]);
            String input = c.getInput();
            ArrayList<String> matchedPlayers = new ArrayList<String>();
            for (ProxiedPlayer player : ProxyServer.getInstance().getPlayers()) {
                String name = player.getName();
                if (!ApacheCommonsLangUtil.startsWithIgnoreCase(name, input)) continue;
                matchedPlayers.add(name);
            }
            matchedPlayers.sort(String.CASE_INSENSITIVE_ORDER);
            return matchedPlayers;
        });
    }
}

