/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.ACFVelocityUtil;
import co.aikar.commands.CommandCompletions;
import co.aikar.commands.CommandManager;
import co.aikar.commands.VelocityCommandCompletionContext;
import co.aikar.commands.apachecommonslang.ApacheCommonsLangUtil;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.format.TextFormat;

public class VelocityCommandCompletions
extends CommandCompletions<VelocityCommandCompletionContext> {
    public VelocityCommandCompletions(ProxyServer server, CommandManager manager) {
        super(manager);
        this.registerAsyncCompletion("chatcolors", c -> {
            String filter;
            Stream<TextFormat> colors = NamedTextColor.NAMES.values().stream().map(namedTextColor -> namedTextColor);
            if (!c.hasConfig("colorsonly")) {
                colors = Stream.concat(colors, Stream.of(TextDecoration.values()));
            }
            if ((filter = c.getConfig("filter")) != null) {
                Set filters = Arrays.stream(ACFPatterns.COLON.split(filter)).map(ACFUtil::simplifyString).collect(Collectors.toSet());
                colors = colors.filter(color -> filters.contains(ACFUtil.simplifyString(color.toString())));
            }
            return colors.map(color -> ACFUtil.simplifyString(color.toString())).collect(Collectors.toList());
        });
        this.registerCompletion("players", c -> {
            CommandSource sender = c.getSender();
            ACFVelocityUtil.validate(sender, "Sender cannot be null", new Object[0]);
            String input = c.getInput();
            ArrayList<String> matchedPlayers = new ArrayList<String>();
            for (Player player : server.getAllPlayers()) {
                String name = player.getUsername();
                if (!ApacheCommonsLangUtil.startsWithIgnoreCase(name, input)) continue;
                matchedPlayers.add(name);
            }
            matchedPlayers.sort(String.CASE_INSENSITIVE_ORDER);
            return matchedPlayers;
        });
    }
}

