/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFVelocityUtil;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.VelocityCommandManager;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public class VelocityCommandIssuer
implements CommandIssuer {
    private final VelocityCommandManager manager;
    private final CommandSource source;

    protected VelocityCommandIssuer(VelocityCommandManager manager, CommandSource source) {
        this.manager = manager;
        this.source = source;
    }

    public CommandSource getIssuer() {
        return this.source;
    }

    public Player getPlayer() {
        return this.isPlayer() ? (Player)this.source : null;
    }

    @Override
    public CommandManager getManager() {
        return this.manager;
    }

    @Override
    public boolean isPlayer() {
        return this.source instanceof Player;
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        if (this.isPlayer()) {
            return ((Player)this.source).getUniqueId();
        }
        return UUID.randomUUID();
    }

    @Override
    public void sendMessageInternal(String message) {
        this.source.sendMessage((Component)ACFVelocityUtil.color(message));
    }

    @Override
    public boolean hasPermission(String name) {
        return this.source.hasPermission(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VelocityCommandIssuer that = (VelocityCommandIssuer)o;
        return Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.source);
    }
}

