/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.simplix.cirrus.effect.AbstractMenuEffect;
import dev.simplix.cirrus.effects.SimpleChangingItemEffect;
import dev.simplix.cirrus.effects.SpectrumEffect;
import dev.simplix.cirrus.effects.WaveEffect;
import dev.simplix.cirrus.gson.CirrusItemDeserializer;
import dev.simplix.cirrus.gson.CirrusItemSerializer;
import dev.simplix.cirrus.gson.ColorDeserializer;
import dev.simplix.cirrus.gson.ColorSerializer;
import dev.simplix.cirrus.gson.ItemStackDeserializer;
import dev.simplix.cirrus.gson.ItemStackSerializer;
import dev.simplix.cirrus.gson.RuntimeTypeAdapterFactory;
import dev.simplix.cirrus.item.CirrusItem;
import dev.simplix.cirrus.mojang.TextureService;
import dev.simplix.cirrus.mojang.UUIDNameService;
import dev.simplix.cirrus.mojangson.TagDeserializer;
import dev.simplix.cirrus.mojangson.TagSerializer;
import dev.simplix.cirrus.service.ColorConvertService;
import dev.simplix.cirrus.service.ItemService;
import dev.simplix.cirrus.service.MenuBuildService;
import dev.simplix.protocolize.api.Protocolize;
import dev.simplix.protocolize.api.item.BaseItemStack;
import dev.simplix.protocolize.api.item.ItemStack;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.querz.nbt.tag.CompoundTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cirrus {
    private static final Logger log = LoggerFactory.getLogger(Cirrus.class);
    private static final Executor executor = Executors.newCachedThreadPool();
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)CompoundTag.class), new TagSerializer()).registerTypeAdapter((Type)((Object)CompoundTag.class), new TagDeserializer()).registerTypeAdapter((Type)((Object)BaseItemStack.class), new ItemStackDeserializer()).registerTypeAdapter((Type)((Object)BaseItemStack.class), new ItemStackSerializer()).registerTypeHierarchyAdapter(CirrusItem.class, new CirrusItemSerializer()).registerTypeHierarchyAdapter(CirrusItem.class, new CirrusItemDeserializer()).registerTypeAdapter((Type)((Object)Color.class), new ColorSerializer()).registerTypeAdapter((Type)((Object)Color.class), new ColorDeserializer()).registerTypeAdapterFactory(Cirrus.animationTypeAdapterFactory()).registerTypeAdapterFactory(Cirrus.itemStackTypeAdapterFactory()).setPrettyPrinting().serializeNulls().create();
    private static boolean canDisplayAsync = true;
    private static boolean canUpdateAsync = true;
    private static boolean isSpigot = false;
    private static MenuBuildService menuBuildService;

    public static void init() {
        Cirrus.registerService(TextureService.class, new TextureService());
        Cirrus.registerService(UUIDNameService.class, new UUIDNameService());
        Cirrus.registerService(ItemService.class, new ItemService());
        Cirrus.registerService(ColorConvertService.class, new ColorConvertService(){

            @Override
            public String colorToString(Color color) {
                String input = "#" + String.format("%08x", color.getRGB()).substring(2);
                StringBuilder output = new StringBuilder("\u00a7x");
                for (char c : input.substring(1).toCharArray()) {
                    output.append("\u00a7").append(c);
                }
                return output.toString();
            }

            @Override
            public Color stringToColor(String hexColor) {
                String replace = hexColor.replace("&", "\u00a7").replace("\u00a7x", "").replace("\u00a7", "");
                int rgb = Integer.parseInt(replace, 16);
                return new Color(rgb);
            }
        });
    }

    public static <T> void registerService(Class<T> clazz, T implementation) {
        Protocolize.registerService(clazz, implementation);
    }

    public static <T> T service(Class<T> clazz) {
        Object result = Protocolize.getService(clazz);
        if (result == null) {
            throw new IllegalArgumentException("Could not find service for class " + clazz);
        }
        return (T)result;
    }

    public static Gson gson() {
        return Objects.requireNonNull(GSON, "GSON must not be null");
    }

    public static Locale defaultLocale() {
        return Objects.requireNonNull(DEFAULT_LOCALE, "DEFAULT_LOCALE must not be null");
    }

    public static boolean canUpdateAsync() {
        return canUpdateAsync;
    }

    public static boolean canDisplayAsync() {
        return canDisplayAsync;
    }

    public static void canUpdateAsync(boolean canDisplayAsync) {
        canUpdateAsync = canDisplayAsync;
    }

    public static void canDisplayAsync(boolean canDisplayAsync) {
        Cirrus.canDisplayAsync = canDisplayAsync;
    }

    public static Executor executor() {
        return Objects.requireNonNull(executor, "executer must not be null");
    }

    public static RuntimeTypeAdapterFactory<?> animationTypeAdapterFactory() {
        return RuntimeTypeAdapterFactory.of(AbstractMenuEffect.class).registerSubtype(SpectrumEffect.class, SpectrumEffect.class.getSimpleName().toLowerCase()).registerSubtype(WaveEffect.class, WaveEffect.class.getSimpleName().toLowerCase()).registerSubtype(SimpleChangingItemEffect.class, SimpleChangingItemEffect.class.getSimpleName().toLowerCase());
    }

    public static RuntimeTypeAdapterFactory<?> itemStackTypeAdapterFactory() {
        return RuntimeTypeAdapterFactory.of(BaseItemStack.class).registerSubtype(CirrusItem.class, CirrusItem.class.getSimpleName().toLowerCase()).registerSubtype(ItemStack.class, ItemStack.class.getSimpleName().toLowerCase()).registerSubtype(BaseItemStack.class, BaseItemStack.class.getSimpleName().toLowerCase());
    }

    public static boolean isSpigot() {
        return isSpigot;
    }

    public static void isSpigot(boolean isSpigot) {
        Cirrus.isSpigot = isSpigot;
    }

    public MenuBuildService menuBuildService() {
        if (menuBuildService == null) {
            throw new IllegalArgumentException("MenuBuildService not initialized yet");
        }
        return menuBuildService;
    }
}

