/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus;

import dev.simplix.protocolize.data.inventory.InventoryType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.NonNull;
import net.querz.nbt.tag.CompoundTag;
import net.querz.nbt.tag.IntTag;
import net.querz.nbt.tag.ListTag;
import net.querz.nbt.tag.ShortTag;
import net.querz.nbt.tag.StringTag;
import net.querz.nbt.tag.Tag;

public final class Utils {
    private static final String STEVE_TEXTURE = "ewogICJ0aW1lc3RhbXAiIDogMTU5MTU3NDcyMzc4MywKICAicHJvZmlsZUlkIiA6ICI4NjY3YmE3MWI4NWE0MDA0YWY1NDQ1N2E5NzM0ZWVkNyIsCiAgInByb2ZpbGVOYW1lIiA6ICJTdGV2ZSIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS82ZDNiMDZjMzg1MDRmZmMwMjI5Yjk0OTIxNDdjNjlmY2Y1OWZkMmVkNzg4NWY3ODUwMjE1MmY3N2I0ZDUwZGUxIgogICAgfSwKICAgICJDQVBFIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS85NTNjYWM4Yjc3OWZlNDEzODNlNjc1ZWUyYjg2MDcxYTcxNjU4ZjIxODBmNTZmYmNlOGFhMzE1ZWE3MGUyZWQ2IgogICAgfQogIH0KfQ==";

    public static Optional<UUID> fromString(String uuidString) {
        if (uuidString == null || uuidString.isEmpty()) {
            return Optional.empty();
        }
        String[] components = uuidString.split("-");
        if (components.length != 5) {
            return Optional.empty();
        }
        return Optional.of(UUID.fromString(uuidString));
    }

    public static InventoryType calculateTypeForContent(int size) {
        if (size <= 9) {
            return InventoryType.GENERIC_9X1;
        }
        if (size <= 18) {
            return InventoryType.GENERIC_9X2;
        }
        if (size <= 27) {
            return InventoryType.GENERIC_9X3;
        }
        if (size <= 36) {
            return InventoryType.GENERIC_9X4;
        }
        if (size <= 45) {
            return InventoryType.GENERIC_9X5;
        }
        return InventoryType.GENERIC_9X6;
    }

    public static int calculateSizeForContent(int size) {
        if (size <= 9) {
            return 9;
        }
        if (size <= 18) {
            return 18;
        }
        if (size <= 27) {
            return 27;
        }
        if (size <= 36) {
            return 36;
        }
        if (size <= 45) {
            return 45;
        }
        return 54;
    }

    public static InventoryType typeOfSize(int size) {
        return switch (size) {
            case 9 -> InventoryType.GENERIC_9X1;
            case 18 -> InventoryType.GENERIC_9X2;
            case 27 -> InventoryType.GENERIC_9X3;
            case 36 -> InventoryType.GENERIC_9X4;
            case 45 -> InventoryType.GENERIC_9X5;
            case 54 -> InventoryType.GENERIC_9X6;
            default -> throw new IllegalArgumentException("Invalid size: " + size);
        };
    }

    public static int sizeOfType(@NonNull InventoryType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return switch (type) {
            case InventoryType.GENERIC_9X1 -> 9;
            case InventoryType.GENERIC_9X2 -> 18;
            case InventoryType.GENERIC_9X3 -> 27;
            case InventoryType.GENERIC_9X4 -> 36;
            case InventoryType.GENERIC_9X5 -> 45;
            case InventoryType.GENERIC_9X6 -> 54;
            default -> 0;
        };
    }

    public static Optional<Long> toLong(String string) {
        try {
            return Optional.of(Long.parseLong(string));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    public static Optional<Integer> toIntOrNull(String string) {
        try {
            return Optional.of(Integer.parseInt(string));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    public static void hideNbtFlags(CompoundTag tag) {
        tag.put("HideFlags", (Tag)new IntTag(127));
    }

    public static List<String> colorize(List<String> toColorize) {
        ArrayList<String> out = new ArrayList<String>();
        for (String lore : toColorize) {
            out.add(lore.replace("&", "\u00a7"));
        }
        return out;
    }

    public static String colorize(String name) {
        return name.replace("&", "\u00a7");
    }

    public static void glow(CompoundTag tag) {
        Utils.hideNbtFlags(tag);
        ListTag enchantments = new ListTag(CompoundTag.class);
        ListTag enchs = new ListTag(CompoundTag.class);
        CompoundTag exampleEnchantment = new CompoundTag();
        exampleEnchantment.put("id", (Tag)new StringTag("minecraft:efficiency"));
        exampleEnchantment.put("lvl", (Tag)new ShortTag(1));
        CompoundTag exampleEnch = new CompoundTag();
        exampleEnch.put("id", (Tag)new ShortTag(1));
        exampleEnch.put("lvl", (Tag)new ShortTag(1));
        enchantments.add((Tag)exampleEnchantment);
        enchs.add((Tag)exampleEnch);
        tag.put("ench", (Tag)enchs);
        tag.put("Enchantments", (Tag)enchantments);
    }

    public static void texture(CompoundTag tag, String textureHash) {
        CompoundTag skullOwner;
        if (!(tag.get("SkullOwner") instanceof CompoundTag)) {
            tag.put("SkullOwner", (Tag)new CompoundTag());
        }
        if ((skullOwner = tag.getCompoundTag("SkullOwner")) == null) {
            skullOwner = new CompoundTag();
        }
        skullOwner.put("Name", (Tag)new StringTag(textureHash));
        CompoundTag properties = skullOwner.getCompoundTag("Properties");
        if (properties == null) {
            properties = new CompoundTag();
        }
        CompoundTag texture = new CompoundTag();
        texture.put("Value", (Tag)new StringTag(textureHash.isEmpty() ? STEVE_TEXTURE : textureHash));
        ListTag textures = new ListTag(CompoundTag.class);
        textures.add((Tag)texture);
        properties.put("textures", (Tag)textures);
        skullOwner.put("Properties", (Tag)properties);
        tag.put("SkullOwner", (Tag)skullOwner);
    }

    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

