/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.actionhandler;

import dev.simplix.cirrus.actionhandler.ActionHandler;
import dev.simplix.cirrus.actionhandlers.AsyncOpenMenuActionHandler;
import dev.simplix.cirrus.actionhandlers.OpenMenuActionHandler;
import dev.simplix.cirrus.menu.Menu;
import dev.simplix.cirrus.menus.AbstractBrowser;
import dev.simplix.cirrus.model.CallResult;
import dev.simplix.cirrus.model.Click;
import dev.simplix.protocolize.data.ItemType;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActionHandlers {
    private static final Logger log = LoggerFactory.getLogger(ActionHandlers.class);

    public static ActionHandler changeClickedItemType(Supplier<ItemType> function) {
        return click -> {
            Object baseItemStack = click.clickedItem();
            baseItemStack.itemType((ItemType)function.get());
            click.clickedMenu().update();
            return CallResult.DENY_GRABBING;
        };
    }

    public static ActionHandler sendMessage(String message) {
        return click -> {
            click.player().sendMessage(message);
            return CallResult.DENY_GRABBING;
        };
    }

    public static ActionHandler openAsync(Function<Click, Menu> function) {
        return new AsyncOpenMenuActionHandler(function);
    }

    public static ActionHandler openMenu(Menu menu) {
        return new OpenMenuActionHandler(menu);
    }

    public static ActionHandler openMenu(AbstractBrowser<?> browser) {
        return click -> {
            browser.display(click.player());
            return CallResult.DENY_GRABBING;
        };
    }

    private ActionHandlers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

