/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.actionhandlers;

import dev.simplix.cirrus.Cirrus;
import dev.simplix.cirrus.actionhandler.ActionHandler;
import dev.simplix.cirrus.menu.Menu;
import dev.simplix.cirrus.model.CallResult;
import dev.simplix.cirrus.model.Click;
import dev.simplix.cirrus.service.RunSyncService;
import java.util.function.Function;

public class AsyncOpenMenuActionHandler
implements ActionHandler {
    private Function<Click, Menu> menuFunction;

    public static AsyncOpenMenuActionHandler of(Function<Click, Menu> menuToOpen) {
        return new AsyncOpenMenuActionHandler(menuToOpen);
    }

    @Override
    public CallResult handle(Click click) {
        try {
            Cirrus.executor().execute(() -> {
                try {
                    Menu apply = this.menuFunction.apply(click);
                    if (Cirrus.canDisplayAsync()) {
                        apply.display(click.player());
                    } else {
                        Cirrus.service(RunSyncService.class).runSync(() -> apply.display(click.player()));
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException("Exception displaying menu", exception);
                }
            });
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception executing task", exception);
        }
        return CallResult.DENY_GRABBING;
    }

    public Function<Click, Menu> getMenuFunction() {
        return this.menuFunction;
    }

    public void setMenuFunction(Function<Click, Menu> menuFunction) {
        this.menuFunction = menuFunction;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncOpenMenuActionHandler)) {
            return false;
        }
        AsyncOpenMenuActionHandler other = (AsyncOpenMenuActionHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Function<Click, Menu> this$menuFunction = this.getMenuFunction();
        Function<Click, Menu> other$menuFunction = other.getMenuFunction();
        return !(this$menuFunction == null ? other$menuFunction != null : !this$menuFunction.equals(other$menuFunction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AsyncOpenMenuActionHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Function<Click, Menu> $menuFunction = this.getMenuFunction();
        result = result * 59 + ($menuFunction == null ? 43 : $menuFunction.hashCode());
        return result;
    }

    public String toString() {
        return "AsyncOpenMenuActionHandler(menuFunction=" + this.getMenuFunction() + ")";
    }

    public AsyncOpenMenuActionHandler(Function<Click, Menu> menuFunction) {
        this.menuFunction = menuFunction;
    }
}

