/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.bungee.menubuilder;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import dev.simplix.cirrus.actionhandler.ActionHandler;
import dev.simplix.cirrus.item.CirrusItem;
import dev.simplix.cirrus.menu.DisplayedMenu;
import dev.simplix.cirrus.menu.Menu;
import dev.simplix.cirrus.menu.Menus;
import dev.simplix.cirrus.model.CallResult;
import dev.simplix.cirrus.model.Click;
import dev.simplix.cirrus.player.CirrusPlayerWrapper;
import dev.simplix.cirrus.service.MenuBuildService;
import dev.simplix.protocolize.api.Protocolize;
import dev.simplix.protocolize.api.chat.ChatElement;
import dev.simplix.protocolize.api.inventory.Inventory;
import dev.simplix.protocolize.api.inventory.InventoryClick;
import dev.simplix.protocolize.api.inventory.InventoryClose;
import dev.simplix.protocolize.api.item.BaseItemStack;
import dev.simplix.protocolize.api.item.ItemStack;
import dev.simplix.protocolize.api.player.ProtocolizePlayer;
import dev.simplix.protocolize.data.packets.OpenWindow;
import dev.simplix.protocolize.data.packets.SetSlot;
import dev.simplix.protocolize.data.packets.WindowItems;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BungeeMenuBuildService
implements MenuBuildService {
    private static final Logger log = LoggerFactory.getLogger(BungeeMenuBuildService.class);
    private final BiMap<UUID, Inventory> protocolizeBuildMap = HashBiMap.create();
    private final Set<Long> usedIDs = new HashSet<Long>();
    private final Consumer<InventoryClose> inventoryCloseConsumer = inventoryClose -> {
        UUID uuid = inventoryClose.player().uniqueId();
        Menus.of(uuid).ifPresent(menu -> {
            Menus.remove(uuid);
            this.protocolizeBuildMap.remove((Object)uuid);
        });
    };
    private final Consumer<InventoryClick> inventoryClickConsumer = inventoryClick -> {
        inventoryClick.cancelled(true);
        Menus.of(inventoryClick.player().uniqueId()).ifPresent(menu -> menu.value().actionHandler(inventoryClick.slot()).ifPresent(actionHandler -> inventoryClick.cancelled(BungeeMenuBuildService.handle(inventoryClick, menu, actionHandler) != CallResult.ALLOW_GRABBING)));
    };

    @Nullable
    private static CallResult handle(InventoryClick inventoryClick, DisplayedMenu menu, ActionHandler actionHandler) {
        CallResult result = null;
        try {
            result = actionHandler.handle(new Click(inventoryClick.clickType(), menu, inventoryClick.clickedItem(), inventoryClick.slot()));
        }
        catch (Exception exception) {
            log.warn("Exception caught in clickhandler", (Throwable)exception);
        }
        return result;
    }

    private static BaseComponent[] removeItalic(String title) {
        BaseComponent[] titleComponent;
        for (BaseComponent component : titleComponent = TextComponent.fromLegacyText((String)title)) {
            if (component.isItalic()) continue;
            component.setItalic(Boolean.valueOf(false));
        }
        return titleComponent;
    }

    private static void setInventoryTitle(String title, Inventory inventory) {
        if (title != null) {
            BaseComponent[] titleComponent = BungeeMenuBuildService.removeItalic(title);
            inventory.title(ChatElement.of((Object)titleComponent));
        }
    }

    @Override
    public DisplayedMenu openAndBuildMenu0(Menu menu, CirrusPlayerWrapper playerWrapper) {
        ProxiedPlayer player = (ProxiedPlayer)playerWrapper.handle();
        Inventory inventory = this.createInventory(menu);
        this.buildMenuIntoInventory(inventory, menu);
        long id = this.generateID();
        ProtocolizePlayer protocolizePlayer = Protocolize.playerProvider().player(player.getUniqueId());
        this.sendInventoryToPlayer(menu, protocolizePlayer, inventory);
        return new DisplayedMenu(menu, inventory, playerWrapper, this, id);
    }

    @Override
    public void updateMenu(DisplayedMenu displayedMenu) {
        Inventory inventory = (Inventory)displayedMenu.nativeMenu();
        ProtocolizePlayer player = Protocolize.playerProvider().player(displayedMenu.player().uuid());
        if (displayedMenu.closed().get()) {
            return;
        }
        if (inventory.type() == displayedMenu.value().type()) {
            this.buildMenuIntoInventory(inventory, displayedMenu.value());
            this.openOrUpdateInventory(player, inventory);
        } else {
            this.buildAndOpenMenu(displayedMenu.value(), displayedMenu.player());
        }
    }

    @Override
    public void closeMenu0(DisplayedMenu displayedMenu) {
        Protocolize.playerProvider().player(displayedMenu.player().uuid()).closeInventory();
    }

    private void sendInventoryToPlayer(Menu menu, ProtocolizePlayer player, Inventory inventory) {
        this.protocolizeBuildMap.put((Object)player.uniqueId(), (Object)inventory);
        this.openOrUpdateInventory(player, inventory);
    }

    private void buildMenuIntoInventory(@NonNull Inventory inventory, @NonNull Menu menu) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (menu == null) {
            throw new NullPointerException("menu is marked non-null but is null");
        }
        BungeeMenuBuildService.setInventoryTitle(menu.title(), inventory);
        menu.rootItems().forEach((BiConsumer<? super Integer, ? super BaseItemStack>)((BiConsumer<Integer, BaseItemStack>)(slot, item) -> {
            ItemStack itemStack;
            Object finalStack = item instanceof ItemStack ? (itemStack = (ItemStack)item) : new CirrusItem((BaseItemStack)item);
            inventory.item(slot.intValue(), finalStack);
        }));
    }

    private Inventory createInventory(@NonNull Menu menu) {
        if (menu == null) {
            throw new NullPointerException("menu is marked non-null but is null");
        }
        Inventory inventory = new Inventory(menu.type());
        inventory.onClose(this.inventoryCloseConsumer);
        inventory.onClick(this.inventoryClickConsumer);
        return inventory;
    }

    private Long generateID() {
        long id = 0L;
        while (this.usedIDs.contains(id)) {
            ++id;
        }
        this.usedIDs.add(id);
        return id;
    }

    private void openOrUpdateInventory(ProtocolizePlayer player, Inventory inventory) {
        int protocolVersion;
        boolean alreadyOpen = false;
        int windowId = -1;
        for (Integer id : player.registeredInventories().keySet()) {
            Inventory val = (Inventory)player.registeredInventories().get(id);
            if (val != inventory) continue;
            windowId = id;
            alreadyOpen = true;
            break;
        }
        if (windowId == -1) {
            windowId = player.generateWindowId();
            player.registerInventory(windowId, inventory);
        }
        try {
            protocolVersion = player.protocolVersion();
        }
        catch (Throwable t) {
            protocolVersion = 47;
        }
        List<BaseItemStack> itemStacks = inventory.itemsIndexed(protocolVersion).stream().map(item -> item).toList();
        if (!alreadyOpen) {
            player.sendPacket((Object)new OpenWindow(windowId, inventory.type(), inventory.title()));
            for (int i = 0; i < itemStacks.size(); ++i) {
                ItemStack itemStack = (ItemStack)itemStacks.get(i);
                if (itemStack == null) continue;
                SetSlot set = new SetSlot((byte)windowId, (short)i, (BaseItemStack)itemStack, 1);
                player.sendPacket((Object)set);
            }
        }
        player.sendPacket((Object)new WindowItems((int)((short)windowId), new ArrayList<BaseItemStack>(itemStacks), 1));
    }
}

