/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.bungee.wrapper;

import dev.simplix.cirrus.Utils;
import dev.simplix.cirrus.model.SimpleSound;
import dev.simplix.cirrus.player.CirrusPlayerWrapper;
import dev.simplix.protocolize.api.Protocolize;
import java.util.UUID;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class BungeePlayerWrapper
implements CirrusPlayerWrapper {
    private final ProxiedPlayer handle;

    @Override
    public UUID uuid() {
        return this.handle.getUniqueId();
    }

    @Override
    public <T> T handle() {
        return (T)this.handle;
    }

    @Override
    public void sendMessage(String message) {
        this.handle.sendMessage(Utils.colorize(message));
    }

    @Override
    public void play(SimpleSound sound) {
        Protocolize.playerProvider().player(this.uuid()).playSound(sound.sound(), sound.soundCategory(), sound.volume(), sound.pitch());
    }

    @Override
    public int protocolVersion() {
        int i;
        try {
            i = Protocolize.playerProvider().player(this.uuid()).protocolVersion();
        }
        catch (Throwable throwable) {
            i = 769;
        }
        return i;
    }

    public BungeePlayerWrapper(ProxiedPlayer handle) {
        this.handle = handle;
    }
}

