/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.effect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import dev.simplix.cirrus.effect.MenuEffect;
import java.util.Iterator;

public abstract class AbstractMenuEffect<T>
implements MenuEffect<T> {
    protected final T input;
    protected final int effectLength;
    private transient Iterator<T> iterator;

    protected AbstractMenuEffect(T input, int effectLength) {
        this.input = Preconditions.checkNotNull(input, (Object)"input must not be null");
        Preconditions.checkState((effectLength > 0 ? 1 : 0) != 0, (Object)"effectLength is not larger than 0");
        this.effectLength = effectLength;
    }

    @Override
    public int effectLength() {
        return this.effectLength;
    }

    @Override
    public final T input() {
        return this.input;
    }

    @Override
    public final T nextFrame() {
        if (this.iterator == null) {
            this.iterator = Iterators.cycle(this.calculate());
        }
        return this.iterator.next();
    }
}

