/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.effects;

import com.google.common.base.Preconditions;
import dev.simplix.cirrus.Cirrus;
import dev.simplix.cirrus.effect.AbstractMenuEffect;
import dev.simplix.cirrus.service.ColorConvertService;
import dev.simplix.cirrus.util.ToStringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveEffect
extends AbstractMenuEffect<String> {
    private static final Logger log = LoggerFactory.getLogger(WaveEffect.class);
    protected final Color[] colors;
    protected final String colorSuffix;
    protected boolean reverse = false;
    protected int transitionCount = 0;

    public WaveEffect(String input, Color[] colors) {
        this(input, "\u00a7l", colors, 2);
    }

    public WaveEffect(String input, String colorSuffix, Color[] colors, int effectLength) {
        super(input, effectLength);
        this.colors = (Color[])Preconditions.checkNotNull((Object)colors, (Object)"colors must not be null");
        this.colorSuffix = (String)Preconditions.checkNotNull((Object)colorSuffix, (Object)"colorSuffix must not be null");
        Preconditions.checkArgument((colors.length > 0 ? 1 : 0) != 0, (Object)"colors must not be empty");
    }

    public static WaveEffect fat(String input, Color ... colors) {
        return new WaveEffect(input, "\u00a7l", colors, 2);
    }

    public WaveEffect reversed() {
        this.reverse = true;
        return this;
    }

    public WaveEffect reverse(boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    public WaveEffect transitionCount(int transitionCount) {
        this.transitionCount = transitionCount;
        return this;
    }

    public WaveEffect length(int length) {
        return new WaveEffect((String)this.input, this.colorSuffix, this.colors, length).reverse(this.reverse).transitionCount(this.transitionCount);
    }

    @Override
    public List<String> calculate() {
        ArrayList<String> out = new ArrayList<String>();
        for (int i = 0; i < this.colors.length; ++i) {
            Color color = this.colors[i];
            int index = this.colors.length == i + 1 ? 0 : i + 1;
            Color color2 = this.colors[index];
            out.addAll(this.insertEffect(Cirrus.service(ColorConvertService.class).colorToString(color) + this.colorSuffix, Cirrus.service(ColorConvertService.class).colorToString(color2) + this.colorSuffix));
        }
        return out;
    }

    private List<String> insertEffect(String effectColor, String primaryColor) {
        ArrayList<String> out = new ArrayList<String>();
        if (this.reverse) {
            for (int i = ((String)this.input).length() - 1; i >= 0; --i) {
                out.addAll(Collections.nCopies(this.effectLength, this.addAtIndex(primaryColor + (String)this.input, effectColor, i + primaryColor.length())));
            }
            if (this.transitionCount != 0) {
                out.addAll(Collections.nCopies(this.transitionCount, effectColor + (String)this.input));
            }
        } else {
            for (int i = 0; i <= ((String)this.input).length(); ++i) {
                out.addAll(Collections.nCopies(this.effectLength, this.addAtIndex(primaryColor + (String)this.input, effectColor, i + primaryColor.length())));
            }
            if (this.transitionCount != 0) {
                out.addAll(Collections.nCopies(this.transitionCount, primaryColor + (String)this.input));
            }
        }
        return out;
    }

    private String addAtIndex(String str, String toAdd, int position) {
        StringBuilder sb = new StringBuilder(str);
        sb.insert(position, toAdd);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaveEffect that = (WaveEffect)o;
        if (this.reverse != that.reverse) {
            return false;
        }
        if (this.transitionCount != that.transitionCount) {
            return false;
        }
        if (!Arrays.equals(this.colors, that.colors)) {
            return false;
        }
        return this.colorSuffix.equals(that.colorSuffix);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.colors);
        result = 31 * result + this.colorSuffix.hashCode();
        result = 31 * result + (this.reverse ? 1 : 0);
        result = 31 * result + this.transitionCount;
        return result;
    }

    public String toString() {
        return ToStringUtil.of(this).add("colors", Arrays.toString(this.colors)).add("colorSuffix", this.colorSuffix).add("reverse", this.reverse).add("transitionCount", this.transitionCount).add("input", this.input).add("effectLength", this.effectLength).toString();
    }
}

