/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.simplix.cirrus.effect.AbstractMenuEffect;
import dev.simplix.cirrus.item.CirrusItem;
import dev.simplix.protocolize.api.chat.ChatElement;
import dev.simplix.protocolize.data.ItemType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import net.querz.nbt.tag.CompoundTag;

public class CirrusItemDeserializer
implements JsonDeserializer<CirrusItem> {
    @Override
    public CirrusItem deserialize(JsonElement jsonElement, Type typeOf, JsonDeserializationContext context) throws JsonParseException {
        JsonObject asJsonObject = jsonElement.getAsJsonObject();
        ItemType type = ItemType.valueOf((String)asJsonObject.get("type").getAsString());
        byte amount = asJsonObject.get("amount").getAsByte();
        byte durability = asJsonObject.get("durability").getAsByte();
        int hideflags = asJsonObject.get("hide-flags").getAsInt();
        JsonElement nbtRaw = asJsonObject.get("nbt");
        CompoundTag nbt = nbtRaw == null ? new CompoundTag() : (CompoundTag)context.deserialize(nbtRaw, (Type)((Object)CompoundTag.class));
        AbstractMenuEffect effect = asJsonObject.get("display-name-effect") != null ? (AbstractMenuEffect)context.deserialize(asJsonObject.get("display-name-effect"), (Type)((Object)AbstractMenuEffect.class)) : null;
        String displayName = null;
        if (effect == null) {
            displayName = asJsonObject.get("display-name").getAsString();
        }
        String actionHandler = asJsonObject.get("action-handler").getAsString();
        List lore = asJsonObject.get("lore") != null ? (List)context.deserialize(asJsonObject.get("lore"), (Type)((Object)List.class)) : null;
        List actionArguments = asJsonObject.get("action-arguments") != null ? (List)context.deserialize(asJsonObject.get("action-arguments"), (Type)((Object)List.class)) : null;
        return new CirrusItem(type).amount(amount).nbtData(nbt).displayName((ChatElement<?>)ChatElement.ofLegacyText((String)displayName)).displayNameEffect(effect).durability(durability).hideFlags(hideflags).actionArguments(actionArguments).actionHandler(actionHandler).loreElements(lore.stream().map(ChatElement::ofLegacyText).collect(Collectors.toList()));
    }
}

