/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.simplix.cirrus.effect.AbstractMenuEffect;
import dev.simplix.cirrus.item.CirrusItem;
import dev.simplix.protocolize.api.chat.ChatElement;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;

public class CirrusItemSerializer
implements JsonSerializer<CirrusItem> {
    @Override
    public JsonElement serialize(CirrusItem src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("TYPE-NAME", new JsonPrimitive(((Object)((Object)src)).getClass().getSimpleName().toLowerCase()));
        String displayName = src.displayName() == null ? null : src.displayName().asLegacyText();
        AbstractMenuEffect<String> effect = src.displayNameEffect();
        if (displayName != null && effect == null) {
            jsonObject.add("display-name", new JsonPrimitive(displayName));
        }
        if (effect != null) {
            jsonObject.add("display-name-effect", context.serialize(effect, (Type)((Object)AbstractMenuEffect.class)));
        }
        jsonObject.add("type", context.serialize(src.itemType()));
        List lores = src.lore().stream().map(ChatElement::asLegacyText).collect(Collectors.toList());
        if (lores != null) {
            jsonObject.add("lore", lores.isEmpty() ? new JsonArray() : context.serialize(lores));
        }
        jsonObject.add("amount", new JsonPrimitive(src.amount()));
        jsonObject.add("durability", new JsonPrimitive(src.durability()));
        jsonObject.add("hide-flags", new JsonPrimitive(src.hideFlags()));
        jsonObject.add("nbt", context.serialize(src.nbtData()));
        jsonObject.add("action-handler", new JsonPrimitive(src.actionHandler() == null ? "noAction" : src.actionHandler()));
        jsonObject.add("flags", context.serialize(src.itemFlags()));
        if (src.actionArguments().isEmpty()) {
            jsonObject.add("action-arguments", new JsonArray());
        } else {
            jsonObject.add("action-arguments", context.serialize(src.actionArguments()));
        }
        return jsonObject;
    }
}

