/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.simplix.protocolize.api.chat.ChatElement;
import dev.simplix.protocolize.api.item.BaseItemStack;
import dev.simplix.protocolize.api.item.ItemStack;
import dev.simplix.protocolize.data.ItemType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import net.querz.nbt.tag.CompoundTag;

public class ItemStackDeserializer
implements JsonDeserializer<BaseItemStack> {
    @Override
    public BaseItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject asJsonObject = json.getAsJsonObject();
        ItemType type = ItemType.valueOf((String)asJsonObject.get("type").getAsString());
        int amount = asJsonObject.get("amount").getAsInt();
        byte durability = asJsonObject.get("durability").getAsByte();
        int hideflags = asJsonObject.get("hide-flags").getAsInt();
        JsonElement nbtRaw = asJsonObject.get("nbt");
        CompoundTag nbt = nbtRaw == null ? new CompoundTag() : (CompoundTag)context.deserialize(nbtRaw, (Type)((Object)CompoundTag.class));
        String displayName = asJsonObject.get("display-name") != null ? asJsonObject.get("display-name").getAsString() : "";
        List lore = asJsonObject.get("lore") != null ? (List)context.deserialize(asJsonObject.get("lore"), (Type)((Object)List.class)) : null;
        ItemStack itemStack = (ItemStack)new ItemStack(type, amount, (short)durability).displayName(ChatElement.ofLegacyText((String)displayName)).nbtData(nbt);
        itemStack.lore(lore.stream().map(ChatElement::ofLegacyText).collect(Collectors.toList()));
        itemStack.hideFlags(hideflags);
        return itemStack;
    }
}

