/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.item;

import dev.simplix.cirrus.Utils;
import dev.simplix.cirrus.effect.AbstractMenuEffect;
import dev.simplix.cirrus.util.ToStringUtil;
import dev.simplix.protocolize.api.chat.ChatElement;
import dev.simplix.protocolize.api.item.BaseItemStack;
import dev.simplix.protocolize.api.item.ItemStack;
import dev.simplix.protocolize.data.ItemType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.querz.nbt.tag.CompoundTag;

public class CirrusItem
extends ItemStack {
    public static CirrusItem NO_DATA = CirrusItem.of(null);
    private String actionHandler = "noAction";
    private transient int slot = -1;
    private List<String> actionArguments = Collections.emptyList();
    @Nullable
    private AbstractMenuEffect<String> displayNameEffect = null;

    public CirrusItem() {
        super(ItemType.STONE);
    }

    public CirrusItem(BaseItemStack baseItemStack) {
        super(baseItemStack);
    }

    public CirrusItem(ItemType itemType) {
        this(itemType, 1);
    }

    public CirrusItem(ItemType itemType, int amount) {
        this(itemType, amount, -1);
    }

    public CirrusItem(ItemType itemType, int amount, short durability) {
        super(itemType, amount, durability);
    }

    public static CirrusItem of(@Nullable ItemType itemType) {
        return new CirrusItem(itemType);
    }

    public static CirrusItem ofSkullHash(@NonNull String skullHash) {
        if (skullHash == null) {
            throw new NullPointerException("skullHash is marked non-null but is null");
        }
        return new CirrusItem(ItemType.PLAYER_HEAD).texture(skullHash);
    }

    public static CirrusItem of(@NonNull ItemType itemType, @NonNull ChatElement<?> displayName, @NonNull List<ChatElement<?>> lore) {
        if (itemType == null) {
            throw new NullPointerException("itemType is marked non-null but is null");
        }
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        if (lore == null) {
            throw new NullPointerException("lore is marked non-null but is null");
        }
        return new CirrusItem(itemType).displayName(displayName).loreElements(lore);
    }

    public static CirrusItem of(@NonNull ItemType itemType, @NonNull ChatElement<?> displayName, ChatElement<?> ... lore) {
        if (itemType == null) {
            throw new NullPointerException("itemType is marked non-null but is null");
        }
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        if (lore == null) {
            throw new NullPointerException("lore is marked non-null but is null");
        }
        return new CirrusItem(itemType).displayName(displayName).lore(lore);
    }

    public static CirrusItem of(@NonNull ItemType itemType, @NonNull AbstractMenuEffect<String> displayNameEffect, ChatElement<?> ... lore) {
        if (itemType == null) {
            throw new NullPointerException("itemType is marked non-null but is null");
        }
        if (displayNameEffect == null) {
            throw new NullPointerException("displayNameEffect is marked non-null but is null");
        }
        if (lore == null) {
            throw new NullPointerException("lore is marked non-null but is null");
        }
        return new CirrusItem(itemType).displayNameEffect(displayNameEffect).lore(lore);
    }

    public CirrusItem loreElements(@Nullable List<ChatElement<?>> lore) {
        if (lore == null) {
            return this;
        }
        this.lore(lore);
        return this;
    }

    public CirrusItem displayName(@Nullable ChatElement<?> displayName) {
        if (displayName == null) {
            return this;
        }
        super.displayName(displayName);
        return this;
    }

    public CirrusItem lore(ChatElement<?> ... lore) {
        if (lore == null) {
            throw new NullPointerException("lore is marked non-null but is null");
        }
        if (lore == null) {
            return this;
        }
        super.lore(Arrays.asList(lore));
        return this;
    }

    public ChatElement<?> displayName() {
        return super.displayName();
    }

    public List<ChatElement<?>> lore() {
        return super.lore();
    }

    public CirrusItem deepClone(int protocolVersion) {
        return (CirrusItem)super.deepClone(protocolVersion);
    }

    public CirrusItem itemType(@NonNull ItemType itemType) {
        if (itemType == null) {
            throw new NullPointerException("itemType is marked non-null but is null");
        }
        return (CirrusItem)super.itemType(itemType);
    }

    public CirrusItem nbtData(@NonNull CompoundTag nbtData) {
        if (nbtData == null) {
            throw new NullPointerException("nbtData is marked non-null but is null");
        }
        return (CirrusItem)super.nbtData(nbtData);
    }

    @Nullable
    public ItemType itemType() {
        return super.itemType();
    }

    public CirrusItem amount(byte amount) {
        return (CirrusItem)super.amount(amount);
    }

    public CirrusItem durability(short durability) {
        return (CirrusItem)super.durability(durability);
    }

    public CirrusItem hideFlags(int hideFlags) {
        return (CirrusItem)super.hideFlags(hideFlags);
    }

    public int slot() {
        return this.slot;
    }

    public CirrusItem slot(int slot) {
        this.slot = slot;
        return this;
    }

    public CirrusItem hideNbtFlags() {
        Utils.hideNbtFlags(this.nbtData());
        return this;
    }

    public CirrusItem glow() {
        Utils.glow(this.nbtData());
        return this;
    }

    public CirrusItem texture(@NonNull String texture) {
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
        Utils.texture(this.nbtData(), texture);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == ItemStack.class) {
            return super.equals(o);
        }
        CirrusItem item = (CirrusItem)((Object)o);
        if (!Objects.equals(this.lore(), item.lore())) {
            return false;
        }
        if (!Objects.equals(this.itemType, item.itemType())) {
            return false;
        }
        if (!Objects.equals(this.actionHandler, item.actionHandler())) {
            return false;
        }
        if (!Objects.equals(this.actionArguments, item.actionArguments())) {
            return false;
        }
        return Objects.equals(this.displayNameEffect, item.displayNameEffect);
    }

    public String toString() {
        return ToStringUtil.of("CirrusItem").add("displayName", this.displayName()).add("displayNameEffect", this.displayNameEffect == null ? "null" : this.displayNameEffect.toString()).add("itemType", this.itemType).add("lore", this.lore()).add("amount", this.amount).add("hideFlags", this.hideFlags).add("actionArguments", this.actionArguments).toString();
    }

    public int hashCode() {
        return Objects.hash(this.itemType, this.amount, this.durability, this.nbtData, this.actionHandler(), this.lore());
    }

    public String actionHandler() {
        return this.actionHandler;
    }

    public List<String> actionArguments() {
        return this.actionArguments;
    }

    @Nullable
    public AbstractMenuEffect<String> displayNameEffect() {
        return this.displayNameEffect;
    }

    public CirrusItem actionHandler(String actionHandler) {
        this.actionHandler = actionHandler;
        return this;
    }

    public CirrusItem actionArguments(List<String> actionArguments) {
        this.actionArguments = actionArguments;
        return this;
    }

    public CirrusItem displayNameEffect(@Nullable AbstractMenuEffect<String> displayNameEffect) {
        this.displayNameEffect = displayNameEffect;
        return this;
    }
}

