/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.item;

import dev.simplix.cirrus.color.StandardColorConfiguration;
import dev.simplix.cirrus.effects.SpectrumEffect;
import dev.simplix.cirrus.effects.WaveEffect;
import dev.simplix.cirrus.item.CirrusItem;
import dev.simplix.cirrus.menu.MenuRow;
import dev.simplix.cirrus.menus.AbstractBrowser;
import dev.simplix.protocolize.api.chat.ChatElement;
import dev.simplix.protocolize.data.ItemType;
import java.awt.Color;
import java.util.function.BiConsumer;

public final class Items {
    public static BiConsumer<AbstractBrowser<?>, MenuRow> defaultBottomRowProvider = (abstractBrowser, bottomRow) -> {
        int totalPages = abstractBrowser.totalPages();
        int previous = abstractBrowser.previousPageNumber();
        int nextPageNumber = abstractBrowser.nextPageNumber();
        if (abstractBrowser.hasPreviousPage()) {
            bottomRow.get(0).set(CirrusItem.of(ItemType.LIME_DYE, ChatElement.ofLegacyText((String)"\u00a7aPrevious page"), ChatElement.ofLegacyText((String)"\u00a77Click to go to the previous page"), ChatElement.ofLegacyText((String)("\u00a77Goto page \u00a78" + previous + " \u00a77of \u00a78" + totalPages))).actionHandler("previousPage"));
        } else {
            bottomRow.get(0).set(CirrusItem.of(ItemType.GRAY_DYE, ChatElement.ofLegacyText((String)"\u00a7aPrevious page"), ChatElement.ofLegacyText((String)"\u00a77There is no previous page")));
        }
        if (abstractBrowser.hasNextPage()) {
            bottomRow.get(1).set(CirrusItem.of(ItemType.LIME_DYE, ChatElement.ofLegacyText((String)"\u00a7aNext page"), ChatElement.ofLegacyText((String)"\u00a77Click to go to the next page"), ChatElement.ofLegacyText((String)("\u00a77Goto page \u00a78" + nextPageNumber + " \u00a77of \u00a78" + totalPages))).actionHandler("nextPage"));
        } else {
            bottomRow.get(1).set(CirrusItem.of(ItemType.GRAY_DYE, ChatElement.ofLegacyText((String)"\u00a7aNext page"), ChatElement.ofLegacyText((String)"\u00a77There is no next page")));
        }
    };

    public static CirrusItem withSpectrumEffect(ItemType itemType, String name, ChatElement<?> ... lores) {
        SpectrumEffect animation = SpectrumEffect.fat(name, StandardColorConfiguration.firstColor, StandardColorConfiguration.accentColor);
        return CirrusItem.of(itemType, animation, lores);
    }

    public static CirrusItem withWaveEffect(ItemType itemType, String name, ChatElement<?> ... lores) {
        WaveEffect animation = WaveEffect.fat(name, Color.WHITE, StandardColorConfiguration.accentColor);
        return CirrusItem.of(itemType, animation, lores);
    }

    private Items() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

