/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.menu;

import dev.simplix.cirrus.item.CirrusItem;
import dev.simplix.cirrus.schematic.MenuSchematic;
import dev.simplix.protocolize.api.item.BaseItemStack;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.NonNull;

public class MenuElement {
    @Nullable
    private transient MenuSchematic menuSchematic;
    @Nullable
    private BaseItemStack item;
    @Nullable
    private Integer slot;
    @Nullable
    private String actionHandler;

    public void set(@NonNull CirrusItem cirrusItem) {
        if (cirrusItem == null) {
            throw new NullPointerException("cirrusItem is marked non-null but is null");
        }
        this.set((BaseItemStack)cirrusItem, cirrusItem.actionHandler());
    }

    public void set(@NonNull BaseItemStack item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        this.set(item, null);
    }

    public void set(@NonNull BaseItemStack item, @Nullable String actionHandler) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        this.actionHandler = actionHandler;
        this.item = item;
        if (this.menuSchematic != null && this.slot != null) {
            this.applyChanges(this.menuSchematic, this.slot);
        }
    }

    public Optional<MenuSchematic> menuSchematic() {
        return Optional.ofNullable(this.menuSchematic);
    }

    public Optional<String> actionHandlerString() {
        return Optional.ofNullable(this.actionHandler);
    }

    public void applyChanges(@NonNull MenuSchematic menuSchematic, int slot) {
        if (menuSchematic == null) {
            throw new NullPointerException("menuSchematic is marked non-null but is null");
        }
        this.slot = slot;
        menuSchematic.set(this.item, slot, this.actionHandler);
    }

    public Optional<BaseItemStack> item() {
        return Optional.ofNullable(this.item);
    }

    public MenuElement(@Nullable MenuSchematic menuSchematic, @Nullable BaseItemStack item, @Nullable Integer slot, @Nullable String actionHandler) {
        this.menuSchematic = menuSchematic;
        this.item = item;
        this.slot = slot;
        this.actionHandler = actionHandler;
    }

    public MenuElement() {
    }

    public MenuElement menuSchematic(@Nullable MenuSchematic menuSchematic) {
        this.menuSchematic = menuSchematic;
        return this;
    }

    public MenuElement item(@Nullable BaseItemStack item) {
        this.item = item;
        return this;
    }

    public MenuElement slot(@Nullable Integer slot) {
        this.slot = slot;
        return this;
    }

    public MenuElement actionHandler(@Nullable String actionHandler) {
        this.actionHandler = actionHandler;
        return this;
    }

    public String toString() {
        return "MenuElement(menuSchematic=" + this.menuSchematic() + ", item=" + this.item() + ", slot=" + this.slot() + ", actionHandler=" + this.actionHandler + ")";
    }

    @Nullable
    public Integer slot() {
        return this.slot;
    }
}

