/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.menu;

import dev.simplix.cirrus.menu.MenuElement;
import dev.simplix.cirrus.util.ToStringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lombok.NonNull;

public class MenuRow
implements Iterable<MenuElement> {
    private final List<MenuElement> items;

    public MenuRow() {
        this(MenuRow.elements());
    }

    public MenuRow(List<MenuElement> items) {
        if (items.size() != 9) {
            throw new IllegalArgumentException("Items#size must be 9 but is " + items.size() + ". There are 9 items in a menu-row");
        }
        this.items = items;
    }

    private static List<MenuElement> elements() {
        ArrayList<MenuElement> menuElements = new ArrayList<MenuElement>(9);
        for (int i = 0; i < 9; ++i) {
            menuElements.add(new MenuElement());
        }
        return menuElements;
    }

    @NonNull
    public MenuElement get(int indexOfItemInRow) {
        MenuElement menuElement = this.items.get(indexOfItemInRow);
        if (menuElement == null) {
            menuElement = new MenuElement();
            this.items.set(indexOfItemInRow, menuElement);
        }
        return menuElement;
    }

    public String toString() {
        return ToStringUtil.of(this).add("items", this.items).toString();
    }

    @Override
    public Iterator<MenuElement> iterator() {
        return this.items.iterator();
    }
}

