/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.menu;

import dev.simplix.cirrus.menu.DisplayedMenu;
import dev.simplix.cirrus.menu.Menus;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuUpdateTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MenuUpdateTask.class);
    private static final Map<Long, Long> idUpdateMillisMap = new ConcurrentHashMap<Long, Long>();

    @Override
    public void run() {
        try {
            Menus.all().forEach(this::run);
        }
        catch (Exception exception) {
            log.error("Could not run update task", (Throwable)exception);
        }
    }

    private void run(DisplayedMenu menu) {
        try {
            this.run0(menu);
        }
        catch (Exception exception) {
            log.error("Could not update menu with id: " + menu.id(), (Throwable)exception);
        }
    }

    private void run0(DisplayedMenu menu) {
        int timeBetweenUpdatesInTicks = menu.value().updateTicks();
        if (timeBetweenUpdatesInTicks < 0) {
            return;
        }
        if (menu.closed().get()) {
            return;
        }
        long timeBetweenUpdatesInMS = (long)timeBetweenUpdatesInTicks * 50L;
        long lastUpdateMillis = idUpdateMillisMap.getOrDefault(menu.id(), 0L);
        long nextUpdateMillis = lastUpdateMillis + timeBetweenUpdatesInMS;
        if (nextUpdateMillis > System.currentTimeMillis()) {
            return;
        }
        menu.update();
        idUpdateMillisMap.put(menu.id(), System.currentTimeMillis());
    }
}

