/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.menu;

import dev.simplix.cirrus.menu.DisplayedMenu;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public final class Menus {
    private static final Map<UUID, DisplayedMenu> menuMap = new ConcurrentHashMap<UUID, DisplayedMenu>();

    public static Optional<DisplayedMenu> of(UUID uuid) {
        return Optional.ofNullable(menuMap.get(uuid));
    }

    public static DisplayedMenu register(UUID uuid, DisplayedMenu menu) {
        return menuMap.put(uuid, menu);
    }

    public static DisplayedMenu remove(UUID uuid) {
        DisplayedMenu remove = menuMap.remove(uuid);
        if (remove != null) {
            remove.value().handleClose();
        }
        return remove;
    }

    public static Collection<DisplayedMenu> all() {
        return Collections.unmodifiableCollection(menuMap.values());
    }

    private Menus() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

