/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.menus;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import dev.simplix.cirrus.Utils;
import dev.simplix.cirrus.actionhandler.ActionHandler;
import dev.simplix.cirrus.actionhandler.RegisteredActionHandler;
import dev.simplix.cirrus.item.CirrusItem;
import dev.simplix.cirrus.item.Items;
import dev.simplix.cirrus.menu.DisplayedMenu;
import dev.simplix.cirrus.menu.Menu;
import dev.simplix.cirrus.menu.MenuElement;
import dev.simplix.cirrus.menu.MenuRow;
import dev.simplix.cirrus.menus.BrowserSchematic;
import dev.simplix.cirrus.menus.SimpleMenu;
import dev.simplix.cirrus.model.BusinessItemMap;
import dev.simplix.cirrus.model.CallResult;
import dev.simplix.cirrus.model.Click;
import dev.simplix.cirrus.player.CirrusPlayerWrapper;
import dev.simplix.protocolize.data.inventory.InventoryType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBrowser<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractBrowser.class);
    public static final String NEXT_PAGE_ACTION_HANDLER = "nextPage";
    public static final String PREVIOUS_PAGE_ACTION_HANDLER = "previousPage";
    public static final String CLICK_ACTION_HANDLER = "Click_";
    private final transient AtomicInteger currentPageIndex = new AtomicInteger(0);
    private final transient BiMap<String, T> mapped = HashBiMap.create();
    protected CallResult standardResult = CallResult.DENY_GRABBING;
    private transient List<BrowserPage> pages = new ArrayList<BrowserPage>();
    private final transient List<RegisteredActionHandler> actionHandlers = new LinkedList<RegisteredActionHandler>();
    private BusinessItemMap businessItemMap;
    @NonNull
    private MenuRow bottomRow = new MenuRow();
    @NonNull
    private String title;
    private InventoryType fixedSize = null;
    private boolean built = false;

    public AbstractBrowser(@NonNull BrowserSchematic browserSchematic) {
        if (browserSchematic == null) {
            throw new NullPointerException("browserSchematic is marked non-null but is null");
        }
        this.loadFrom(browserSchematic);
    }

    public AbstractBrowser(List<BrowserPage> pages) {
        this.pages = pages;
    }

    public DisplayedMenu display(CirrusPlayerWrapper player) {
        if (!this.built) {
            this.build();
        }
        return this.currentPage().display(player);
    }

    public void registerActionHandler(String name, Consumer<Click> consumer) {
        this.actionHandlers.add(new RegisteredActionHandler(name, click -> {
            consumer.accept(click);
            return CallResult.DENY_GRABBING;
        }));
    }

    public void registerActionHandler(String name, ActionHandler actionHandler) {
        this.actionHandlers.add(new RegisteredActionHandler(name, actionHandler));
    }

    public void loadFrom(BrowserSchematic browserSchematic) {
        this.title = browserSchematic.title();
        if (browserSchematic.bottomRow() != null) {
            this.bottomRow = browserSchematic.bottomRow();
        }
        if (browserSchematic.standardResult() != null) {
            this.standardResult = browserSchematic.standardResult();
        }
        if (browserSchematic.fixedSize() != null) {
            this.fixedSize = browserSchematic.fixedSize();
        }
        if (browserSchematic.businessItemMap() != null) {
            this.businessItemMap = browserSchematic.businessItemMap();
        }
    }

    public int currentPageNumber() {
        return this.currentPageIndex.get() + 1;
    }

    public int totalPages() {
        return this.pages().size();
    }

    public int nextPageNumber() {
        return this.currentPageIndex.get() + 2;
    }

    public int previousPageNumber() {
        return this.currentPageIndex.get();
    }

    public boolean hasNextPage() {
        return this.currentPageIndex.get() < this.pages.size() - 1;
    }

    public boolean hasPreviousPage() {
        return this.currentPageIndex.get() > 0;
    }

    protected void registerActionHandlers() {
    }

    protected int updateTicks() {
        return -1;
    }

    protected abstract void handleClick(Click var1, T var2);

    protected abstract Collection<T> elements();

    protected abstract CirrusItem map(T var1);

    protected boolean addPageNumberToTitle() {
        return true;
    }

    protected String titleAddon(List<List<CirrusItem>> pages) {
        return " (" + this.currentPageNumber() + "/" + pages.size() + ")";
    }

    protected void interceptBottomRow(MenuRow bottomRow) {
    }

    private void build() {
        this.built = true;
        this.registerActionHandlers();
        int maximumSizeOfAllMenus = this.fixedSize == null ? Utils.calculateSizeForContent(this.elements().size()) : Utils.sizeOfType(this.fixedSize);
        int maximumItemsPerPage = maximumSizeOfAllMenus - 9;
        this.currentPageIndex.set(0);
        if (this.elements() == null) {
            return;
        }
        List collect = this.elements().stream().map(this::mapAndPut).collect(Collectors.toList());
        if (maximumItemsPerPage == 0 || collect.isEmpty()) {
            this.currentPage().type(this.fixedSize);
            this.currentPage().title(this.title() + (this.addPageNumberToTitle() ? " (0/0)" : ""));
            return;
        }
        List pages = Lists.partition(collect, (int)maximumItemsPerPage);
        for (List page : pages) {
            BrowserPage menu = this.currentPage();
            int size = page.size() + 9;
            for (int i = 0; i < page.size(); ++i) {
                CirrusItem cirrusItem = (CirrusItem)((Object)page.get(i));
                cirrusItem.slot(i);
                cirrusItem.actionHandler(CLICK_ACTION_HANDLER);
                menu.set(cirrusItem);
            }
            menu.type(Utils.calculateTypeForContent(size));
            String stringToAdd = this.titleAddon(pages);
            menu.title(this.title() + (this.addPageNumberToTitle() ? stringToAdd : ""));
            this.currentPageIndex.incrementAndGet();
        }
        this.currentPageIndex.set(0);
    }

    private BrowserPage currentPage() {
        BrowserPage got;
        int index = Math.max(this.currentPageIndex.get(), 0);
        BrowserPage browserPage = got = this.pages.size() > index ? this.pages.get(index) : null;
        if (got == null) {
            got = new BrowserPage();
            this.registerActionHandlersForMenu(got);
            this.pages.add(got);
        }
        return got;
    }

    private CirrusItem mapAndPut(T element) {
        CirrusItem result = this.map(element);
        String toString = element.toString();
        this.mapped.put((Object)toString, element);
        result.actionArguments(Collections.singletonList(toString));
        return result;
    }

    private void registerActionHandlersForMenu(Menu menu) {
        menu.registerActionHandler(CLICK_ACTION_HANDLER, (Click click) -> {
            Object t = this.mapped.get((Object)click.arguments().get(0));
            if (t != null) {
                this.handleClick((Click)click, (T)t);
            }
        });
        menu.registerActionHandler(NEXT_PAGE_ACTION_HANDLER, (Click click) -> {
            if (this.hasNextPage()) {
                this.currentPageIndex.incrementAndGet();
                this.currentPage().display(click.player());
            }
        });
        menu.registerActionHandler(PREVIOUS_PAGE_ACTION_HANDLER, (Click click) -> {
            if (this.hasPreviousPage()) {
                this.currentPageIndex.decrementAndGet();
                this.currentPage().display(click.player());
            }
        });
        for (RegisteredActionHandler actionHandler : this.actionHandlers()) {
            menu.registerActionHandler(actionHandler.name(), actionHandler.handler());
        }
    }

    protected final AtomicInteger currentPageIndex() {
        return this.currentPageIndex;
    }

    protected final BiMap<String, T> mapped() {
        return this.mapped;
    }

    protected final CallResult standardResult() {
        return this.standardResult;
    }

    protected final List<BrowserPage> pages() {
        return this.pages;
    }

    protected final List<RegisteredActionHandler> actionHandlers() {
        return this.actionHandlers;
    }

    protected final BusinessItemMap businessItemMap() {
        return this.businessItemMap;
    }

    @NonNull
    protected final MenuRow bottomRow() {
        return this.bottomRow;
    }

    @NonNull
    protected final String title() {
        return this.title;
    }

    protected final InventoryType fixedSize() {
        return this.fixedSize;
    }

    protected final boolean built() {
        return this.built;
    }

    protected final AbstractBrowser<T> standardResult(CallResult standardResult) {
        this.standardResult = standardResult;
        return this;
    }

    protected final AbstractBrowser<T> pages(List<BrowserPage> pages) {
        this.pages = pages;
        return this;
    }

    protected final AbstractBrowser<T> businessItemMap(BusinessItemMap businessItemMap) {
        this.businessItemMap = businessItemMap;
        return this;
    }

    protected final AbstractBrowser<T> bottomRow(@NonNull MenuRow bottomRow) {
        if (bottomRow == null) {
            throw new NullPointerException("bottomRow is marked non-null but is null");
        }
        this.bottomRow = bottomRow;
        return this;
    }

    protected final AbstractBrowser<T> title(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
        return this;
    }

    protected final AbstractBrowser<T> fixedSize(InventoryType fixedSize) {
        this.fixedSize = fixedSize;
        return this;
    }

    protected final AbstractBrowser<T> built(boolean built) {
        this.built = built;
        return this;
    }

    public AbstractBrowser() {
    }

    public AbstractBrowser(CallResult standardResult, List<BrowserPage> pages, BusinessItemMap businessItemMap, @NonNull MenuRow bottomRow, @NonNull String title, InventoryType fixedSize, boolean built) {
        if (bottomRow == null) {
            throw new NullPointerException("bottomRow is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.standardResult = standardResult;
        this.pages = pages;
        this.businessItemMap = businessItemMap;
        this.bottomRow = bottomRow;
        this.title = title;
        this.fixedSize = fixedSize;
        this.built = built;
    }

    private class BrowserPage
    extends SimpleMenu {
        @Override
        protected void handleDisplay0() {
            Items.defaultBottomRowProvider.accept(AbstractBrowser.this, AbstractBrowser.this.bottomRow);
            AbstractBrowser.this.interceptBottomRow(AbstractBrowser.this.bottomRow);
            int contentSize = this.typicalSize() - 9;
            for (int rowIndex = 0; rowIndex < 9; ++rowIndex) {
                int absoluteIndex = contentSize + rowIndex;
                MenuElement menuElement = AbstractBrowser.this.bottomRow.get(rowIndex);
                menuElement.item().ifPresent(baseItemStack -> menuElement.applyChanges(this, absoluteIndex));
            }
        }

        @Override
        public int updateTicks() {
            return AbstractBrowser.this.updateTicks();
        }
    }
}

