/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.menus.example;

import dev.simplix.cirrus.Cirrus;
import dev.simplix.cirrus.actionhandler.ActionHandlers;
import dev.simplix.cirrus.item.CirrusItem;
import dev.simplix.cirrus.item.Items;
import dev.simplix.cirrus.menu.MenuRow;
import dev.simplix.cirrus.menus.AbstractBrowser;
import dev.simplix.cirrus.menus.example.SelectMenu;
import dev.simplix.cirrus.model.Click;
import dev.simplix.cirrus.service.ItemService;
import dev.simplix.protocolize.api.chat.ChatElement;
import dev.simplix.protocolize.data.ItemType;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemTypeBrowser
extends AbstractBrowser<ItemType> {
    private static final Logger log = LoggerFactory.getLogger(ItemTypeBrowser.class);
    private final int protocolVersion;

    public ItemTypeBrowser(int protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.title("\u00a77Item Browser");
    }

    @Override
    protected int updateTicks() {
        return 2;
    }

    @Override
    protected void registerActionHandlers() {
        this.registerActionHandler("back", ActionHandlers.openMenu(new SelectMenu()));
    }

    @Override
    protected void interceptBottomRow(MenuRow bottomRow) {
        bottomRow.get(8).set(CirrusItem.of(ItemType.ACACIA_DOOR, ChatElement.ofLegacyText((String)"\u00a77Back"), ChatElement.ofLegacyText((String)"\u00a77Go back to the previous menu")).actionHandler("back"));
    }

    @Override
    protected void handleClick(Click click, ItemType value) {
        click.player().sendMessage("\u00a77You clicked on " + value.name());
    }

    @Override
    protected Collection<ItemType> elements() {
        return Arrays.stream(ItemType.values()).filter(type -> Cirrus.service(ItemService.class).isItemAvailable((ItemType)type, this.protocolVersion)).toList();
    }

    @Override
    protected CirrusItem map(ItemType element) {
        return Items.withWaveEffect(element, element.name(), new ChatElement[0]);
    }
}

