/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.mojang;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.simplix.cirrus.mojang.UUIDTypeAdapter;
import dev.simplix.cirrus.util.LoadingCache;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public final class MojangTextureFetcher {
    private static final String STEVE_TEXTURE = "ewogICJ0aW1lc3RhbXAiIDogMTU5MTU3NDcyMzc4MywKICAicHJvZmlsZUlkIiA6ICI4NjY3YmE3MWI4NWE0MDA0YWY1NDQ1N2E5NzM0ZWVkNyIsCiAgInByb2ZpbGVOYW1lIiA6ICJTdGV2ZSIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS82ZDNiMDZjMzg1MDRmZmMwMjI5Yjk0OTIxNDdjNjlmY2Y1OWZkMmVkNzg4NWY3ODUwMjE1MmY3N2I0ZDUwZGUxIgogICAgfSwKICAgICJDQVBFIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS85NTNjYWM4Yjc3OWZlNDEzODNlNjc1ZWUyYjg2MDcxYTcxNjU4ZjIxODBmNTZmYmNlOGFhMzE1ZWE3MGUyZWQ2IgogICAgfQogIH0KfQ==";
    public static final String SERVICE_URL = "https://sessionserver.mojang.com/session/minecraft/profile/";
    private static final LoadingCache<UUID, String> cache = new LoadingCache<UUID, String>(30L, TimeUnit.MINUTES, new LoadingCache.CacheLoader<UUID, String>(){

        @Override
        public String load(UUID uuid) {
            return MojangTextureFetcher.fetch0(uuid);
        }
    });

    public static String getTextureHash(UUID uuid) {
        return cache.get(uuid);
    }

    public static String fetch(UUID uuid) {
        try {
            String out = MojangTextureFetcher.fetch0(uuid);
            if (MojangTextureFetcher.isValid(out)) {
                cache.put(uuid, out);
                return out;
            }
        }
        catch (Throwable throwable) {
            System.err.println("If you aren't in online mode, disable it in your settings.yml as well!");
            System.err.println("Using Steve-Texture as default");
            throwable.printStackTrace();
        }
        return STEVE_TEXTURE;
    }

    private static String fetch0(UUID uuid) throws Exception {
        URL url_1 = new URL(SERVICE_URL + UUIDTypeAdapter.fromUUID(uuid) + "?unsigned=false");
        InputStreamReader reader_1 = new InputStreamReader(url_1.openStream());
        JsonObject textureProperty = new JsonParser().parse(reader_1).getAsJsonObject().get("properties").getAsJsonArray().get(0).getAsJsonObject();
        return textureProperty.get("value").getAsString();
    }

    private static boolean isValid(Object hash) {
        if (!(hash instanceof String)) {
            return false;
        }
        return !((String)hash).isEmpty() && !hash.equals(STEVE_TEXTURE);
    }

    private MojangTextureFetcher() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

