/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.mojang;

import dev.simplix.cirrus.util.LoadingCache;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UUIDFetcher {
    private static final Logger log = LoggerFactory.getLogger(UUIDFetcher.class);
    private static final String urlString = "https://mcuuid.net/?q=";
    private static final LoadingCache<UUID, String> nameCache = new LoadingCache<UUID, String>(30L, TimeUnit.MINUTES, new LoadingCache.CacheLoader<UUID, String>(){

        @Override
        public String load(UUID uuid) {
            URL url = UUIDFetcher.getURL(uuid.toString());
            for (String line : UUIDFetcher.readStringArrayFromUrl(url)) {
                if (!line.startsWith("<h3>")) continue;
                return line.replace("<h3>", "").replace("</h3>", "");
            }
            return null;
        }
    });
    private static final LoadingCache<String, UUID> uuidCache = new LoadingCache<String, UUID>(30L, TimeUnit.MINUTES, new LoadingCache.CacheLoader<String, UUID>(){

        @Override
        public UUID load(String s) {
            URL url = UUIDFetcher.getURL(s);
            for (String line : UUIDFetcher.readStringArrayFromUrl(url)) {
                if (!line.startsWith("<td><input type=\"text\" class=\"form-control\" onclick=\"this.select();\" readonly=\"readonly\" value=\"")) continue;
                String[] parts = line.split("\\s");
                return UUID.fromString(parts[5].replace("value=", "").replace("\"", ""));
            }
            return null;
        }
    });

    private static String[] readStringArrayFromUrl(URL url) {
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.addRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
            return new Scanner(urlConnection.getInputStream(), "UTF-8").useDelimiter("\\A").next().split("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    public static String getName(UUID uuid) {
        return nameCache.get(uuid);
    }

    private static URL getURL(String name) {
        try {
            return new URL(urlString + name);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            log.error("Malformed URL: {}", (Object)(urlString + name));
            throw new IllegalStateException("Cant return null. (UUIDFetcher.getURL())");
        }
    }

    public static UUID getUUID(String name) {
        return uuidCache.get(name);
    }

    private UUIDFetcher() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

