/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.mojangson;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Objects;

public class MojangsonWriter
extends JsonWriter {
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;
    private final Writer out;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String indent;
    private final String separator = ":";
    private boolean lenient;
    private boolean htmlSafe;
    private String deferredName;
    private final boolean serializeNulls = true;

    public MojangsonWriter(Writer out) {
        super(out);
        this.push(6);
        if (out == null) {
            throw new NullPointerException("out == null");
        }
        this.out = out;
        this.setLenient(true);
    }

    @Override
    public MojangsonWriter beginArray() throws IOException {
        this.writeDeferredName();
        return this.open(1, '[');
    }

    @Override
    public MojangsonWriter endArray() throws IOException {
        return this.close(1, 2, ']');
    }

    @Override
    public MojangsonWriter beginObject() throws IOException {
        this.writeDeferredName();
        return this.open(3, '{');
    }

    @Override
    public MojangsonWriter endObject() throws IOException {
        return this.close(3, 5, '}');
    }

    private MojangsonWriter open(int empty, char openBracket) throws IOException {
        this.beforeValue();
        this.push(empty);
        this.out.write(openBracket);
        return this;
    }

    private MojangsonWriter close(int empty, int nonempty, char closeBracket) throws IOException {
        int context = this.peek();
        if (context != nonempty && context != empty) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException("Dangling name: " + this.deferredName);
        }
        --this.stackSize;
        if (context == nonempty) {
            this.newline();
        }
        this.out.write(closeBracket);
        return this;
    }

    private void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.stackSize * 2);
        }
        this.stack[this.stackSize++] = newTop;
    }

    private int peek() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("MojangsonWriter is closed.");
        }
        return this.stack[this.stackSize - 1];
    }

    private void replaceTop(int topOfStack) {
        this.stack[this.stackSize - 1] = topOfStack;
    }

    @Override
    public MojangsonWriter name(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException();
        }
        if (this.stackSize == 0) {
            throw new IllegalStateException("MojangsonWriter is closed.");
        }
        this.deferredName = name;
        return this;
    }

    private void writeDeferredName() throws IOException {
        if (this.deferredName != null) {
            this.beforeName();
            this.string(this.deferredName);
            this.deferredName = null;
        }
    }

    @Override
    public MojangsonWriter value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.string(value);
        return this;
    }

    @Override
    public MojangsonWriter jsonValue(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.append(value);
        return this;
    }

    @Override
    public MojangsonWriter nullValue() throws IOException {
        if (this.deferredName != null) {
            Objects.requireNonNull(this);
            this.writeDeferredName();
        }
        this.beforeValue();
        this.out.write("null");
        return this;
    }

    @Override
    public MojangsonWriter value(boolean value) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(value ? "true" : "false");
        return this;
    }

    @Override
    public MojangsonWriter value(Boolean value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(value != false ? "true" : "false");
        return this;
    }

    @Override
    public MojangsonWriter value(double value) throws IOException {
        this.writeDeferredName();
        if (!this.lenient && (Double.isNaN(value) || Double.isInfinite(value))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.beforeValue();
        this.out.append(Double.toString(value));
        return this;
    }

    @Override
    public MojangsonWriter value(long value) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(Long.toString(value));
        return this;
    }

    @Override
    public MojangsonWriter value(Number value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        String string = value.toString();
        if (!this.lenient && (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN"))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.beforeValue();
        this.out.append(string);
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (this.stackSize == 0) {
            throw new IllegalStateException("MojangsonWriter is closed.");
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        int size = this.stackSize;
        if (size > 1 || size == 1 && this.stack[size - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.stackSize = 0;
    }

    private void newline() throws IOException {
        if (this.indent == null) {
            return;
        }
        this.out.write(10);
        int size = this.stackSize;
        for (int i = 1; i < size; ++i) {
            this.out.write(this.indent);
        }
    }

    private void beforeName() throws IOException {
        int context = this.peek();
        if (context == 5) {
            this.out.write(44);
        } else if (context != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.newline();
        this.replaceTop(4);
    }

    private void beforeValue() throws IOException {
        switch (this.peek()) {
            case 7: {
                if (!this.lenient) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case 6: {
                this.replaceTop(7);
                break;
            }
            case 1: {
                this.replaceTop(2);
                this.newline();
                break;
            }
            case 2: {
                this.out.append(',');
                this.newline();
                break;
            }
            case 4: {
                this.out.append(this.separator);
                this.replaceTop(5);
                break;
            }
            default: {
                throw new IllegalStateException("Nesting problem.");
            }
        }
    }

    private void string(String value) throws IOException {
        int length;
        int last;
        boolean quotesNeeded = value.contains(" ") || value.isEmpty();
        for (char c : value.toCharArray()) {
            if (c <= 'z' && (c <= '9' || c >= 'A') && c >= '0' && (c <= 'Z' || c >= 'a')) continue;
            quotesNeeded = true;
            break;
        }
        if (quotesNeeded) {
            this.out.write(34);
        }
        if ((last = 0) < (length = value.length())) {
            this.out.write(value, last, length - last);
        }
        if (quotesNeeded) {
            this.out.write(34);
        }
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            MojangsonWriter.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        MojangsonWriter.REPLACEMENT_CHARS[34] = "\\\"";
        MojangsonWriter.REPLACEMENT_CHARS[92] = "\\\\";
        MojangsonWriter.REPLACEMENT_CHARS[9] = "\\t";
        MojangsonWriter.REPLACEMENT_CHARS[8] = "\\b";
        MojangsonWriter.REPLACEMENT_CHARS[10] = "\\n";
        MojangsonWriter.REPLACEMENT_CHARS[13] = "\\r";
        MojangsonWriter.REPLACEMENT_CHARS[12] = "\\f";
        HTML_SAFE_REPLACEMENT_CHARS = (String[])REPLACEMENT_CHARS.clone();
        MojangsonWriter.HTML_SAFE_REPLACEMENT_CHARS[60] = "\\u003c";
        MojangsonWriter.HTML_SAFE_REPLACEMENT_CHARS[62] = "\\u003e";
        MojangsonWriter.HTML_SAFE_REPLACEMENT_CHARS[38] = "\\u0026";
        MojangsonWriter.HTML_SAFE_REPLACEMENT_CHARS[61] = "\\u003d";
        MojangsonWriter.HTML_SAFE_REPLACEMENT_CHARS[39] = "\\u0027";
    }
}

