/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.mojangson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import dev.simplix.cirrus.mojangson.MojangsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Type;
import lombok.NonNull;
import net.querz.nbt.io.SNBTUtil;
import net.querz.nbt.tag.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TagDeserializer
implements JsonDeserializer<Tag<?>> {
    private static final Logger log = LoggerFactory.getLogger(TagDeserializer.class);
    private static final Gson GSON = new GsonBuilder().create();

    @Override
    public Tag<?> deserialize(@NonNull JsonElement json, @NonNull Type typeOfT, @NonNull JsonDeserializationContext context) throws JsonParseException {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (typeOfT == null) {
            throw new NullPointerException("typeOfT is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (!json.isJsonObject()) {
            throw new IllegalArgumentException("Expected json object!");
        }
        StringWriter stringWriter = new StringWriter();
        try {
            GSON.toJson(json, new MojangsonWriter(stringWriter));
            return SNBTUtil.fromSNBT((String)stringWriter.toString());
        }
        catch (IOException e) {
            log.error("Something went wrong while parsing SNBT string: " + stringWriter.toString());
            throw new RuntimeException(e);
        }
    }
}

